/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.GlobalStatistics;
import org.apache.iceberg.flink.sink.shuffle.StatisticsUtil;

@Internal
class StatisticsEvent
implements OperatorEvent {
    private static final long serialVersionUID = 1L;
    private final long checkpointId;
    private final byte[] statisticsBytes;
    private final boolean applyImmediately;

    private StatisticsEvent(long checkpointId, byte[] statisticsBytes, boolean applyImmediately) {
        this.checkpointId = checkpointId;
        this.statisticsBytes = statisticsBytes;
        this.applyImmediately = applyImmediately;
    }

    static StatisticsEvent createTaskStatisticsEvent(long checkpointId, DataStatistics statistics, TypeSerializer<DataStatistics> statisticsSerializer) {
        return new StatisticsEvent(checkpointId, StatisticsUtil.serializeDataStatistics(statistics, statisticsSerializer), true);
    }

    static StatisticsEvent createGlobalStatisticsEvent(GlobalStatistics statistics, TypeSerializer<GlobalStatistics> statisticsSerializer, boolean applyImmediately) {
        return new StatisticsEvent(statistics.checkpointId(), StatisticsUtil.serializeGlobalStatistics(statistics, statisticsSerializer), applyImmediately);
    }

    long checkpointId() {
        return this.checkpointId;
    }

    byte[] statisticsBytes() {
        return this.statisticsBytes;
    }

    boolean applyImmediately() {
        return this.applyImmediately;
    }
}

