/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.flink.sink.shuffle.GlobalStatisticsSerializer;
import org.apache.iceberg.flink.sink.shuffle.SortKeySerializer;
import org.apache.iceberg.flink.sink.shuffle.StatisticsOrRecord;
import org.apache.iceberg.flink.sink.shuffle.StatisticsOrRecordSerializer;
import org.apache.iceberg.flink.util.FlinkCompatibilityUtil;

public class StatisticsOrRecordTypeInformation
extends TypeInformation<StatisticsOrRecord> {
    private final TypeInformation<RowData> rowTypeInformation;
    private final SortOrder sortOrder;
    private final GlobalStatisticsSerializer globalStatisticsSerializer;

    public StatisticsOrRecordTypeInformation(RowType flinkRowType, Schema schema, SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        this.rowTypeInformation = FlinkCompatibilityUtil.toTypeInfo(flinkRowType);
        this.globalStatisticsSerializer = new GlobalStatisticsSerializer(new SortKeySerializer(schema, sortOrder));
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<StatisticsOrRecord> getTypeClass() {
        return StatisticsOrRecord.class;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<StatisticsOrRecord> createSerializer(SerializerConfig config) {
        TypeSerializer recordSerializer = this.rowTypeInformation.createSerializer(config);
        return new StatisticsOrRecordSerializer(this.globalStatisticsSerializer, (TypeSerializer<RowData>)recordSerializer);
    }

    public TypeSerializer<StatisticsOrRecord> createSerializer(ExecutionConfig config) {
        return this.createSerializer(config.getSerializerConfig());
    }

    public String toString() {
        return "StatisticsOrRecord";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && ((Object)((Object)this)).getClass() == o.getClass()) {
            StatisticsOrRecordTypeInformation that = (StatisticsOrRecordTypeInformation)((Object)o);
            return that.sortOrder.equals((Object)this.sortOrder) && that.rowTypeInformation.equals(this.rowTypeInformation) && that.globalStatisticsSerializer.equals((Object)this.globalStatisticsSerializer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowTypeInformation, this.sortOrder, this.globalStatisticsSerializer});
    }

    public boolean canEqual(Object obj) {
        return obj instanceof StatisticsOrRecordTypeInformation;
    }
}

