/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.DataTaskReader;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.flink.source.FlinkInputSplit;
import org.apache.iceberg.flink.source.FlinkSplitPlanner;
import org.apache.iceberg.flink.source.RowDataFileScanTaskReader;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.util.ThreadPools;

public class FlinkInputFormat
extends RichInputFormat<RowData, FlinkInputSplit> {
    private static final long serialVersionUID = 1L;
    private final TableLoader tableLoader;
    private final FileIO io;
    private final EncryptionManager encryption;
    private final ScanContext context;
    private final FileScanTaskReader rowDataReader;
    private transient DataIterator<RowData> iterator;
    private transient long currentReadCount = 0L;

    FlinkInputFormat(TableLoader tableLoader, Schema tableSchema, FileIO io, EncryptionManager encryption, ScanContext context) {
        this.tableLoader = tableLoader;
        this.io = io;
        this.encryption = encryption;
        this.context = context;
        tableLoader.open();
        Table table = tableLoader.loadTable();
        this.rowDataReader = table instanceof BaseMetadataTable ? new DataTaskReader(context.project()) : new RowDataFileScanTaskReader(tableSchema, context.project(), context.nameMapping(), context.caseSensitive(), context.filters());
    }

    @VisibleForTesting
    Schema projectedSchema() {
        return this.context.project();
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
        return null;
    }

    public FlinkInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        this.tableLoader.open();
        ExecutorService workerPool = ThreadPools.newFixedThreadPool((String)"iceberg-plan-worker-pool", (int)this.context.planParallelism());
        try {
            FlinkInputSplit[] flinkInputSplitArray;
            block9: {
                TableLoader loader = this.tableLoader;
                try {
                    Table table = loader.loadTable();
                    flinkInputSplitArray = FlinkSplitPlanner.planInputSplits(table, this.context, workerPool);
                    if (loader == null) break block9;
                }
                catch (Throwable throwable) {
                    if (loader != null) {
                        try {
                            loader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                loader.close();
            }
            return flinkInputSplitArray;
        }
        finally {
            workerPool.shutdown();
        }
    }

    public InputSplitAssigner getInputSplitAssigner(FlinkInputSplit[] inputSplits) {
        return this.context.exposeLocality() ? new LocatableInputSplitAssigner((LocatableInputSplit[])inputSplits) : new DefaultInputSplitAssigner((InputSplit[])inputSplits);
    }

    public void configure(Configuration parameters) {
    }

    public void open(FlinkInputSplit split) {
        this.iterator = new DataIterator(this.rowDataReader, split.getTask(), this.io, this.encryption);
    }

    public boolean reachedEnd() {
        if (this.context.limit() > 0L && this.currentReadCount >= this.context.limit()) {
            return true;
        }
        return !this.iterator.hasNext();
    }

    public RowData nextRecord(RowData reuse) {
        ++this.currentReadCount;
        return this.iterator.next();
    }

    public void close() throws IOException {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

