/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.FlinkReadConf;
import org.apache.iceberg.flink.FlinkReadOptions;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;

@Internal
public class ScanContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean caseSensitive;
    private final boolean exposeLocality;
    private final Long snapshotId;
    private final String branch;
    private final String tag;
    private final StreamingStartingStrategy startingStrategy;
    private final Long startSnapshotId;
    private final Long startSnapshotTimestamp;
    private final Long endSnapshotId;
    private final Long asOfTimestamp;
    private final String startTag;
    private final String endTag;
    private final Long splitSize;
    private final Integer splitLookback;
    private final Long splitOpenFileCost;
    private final boolean isStreaming;
    private final Duration monitorInterval;
    private final String nameMapping;
    private final Schema schema;
    private final List<Expression> filters;
    private final long limit;
    private final boolean includeColumnStats;
    private final Collection<String> includeStatsForColumns;
    private final Integer planParallelism;
    private final int maxPlanningSnapshotCount;
    private final int maxAllowedPlanningFailures;
    private final String watermarkColumn;
    private final TimeUnit watermarkColumnTimeUnit;

    private ScanContext(boolean caseSensitive, Long snapshotId, StreamingStartingStrategy startingStrategy, Long startSnapshotTimestamp, Long startSnapshotId, Long endSnapshotId, Long asOfTimestamp, Long splitSize, Integer splitLookback, Long splitOpenFileCost, boolean isStreaming, Duration monitorInterval, String nameMapping, Schema schema, List<Expression> filters, long limit, boolean includeColumnStats, Collection<String> includeStatsForColumns, boolean exposeLocality, Integer planParallelism, int maxPlanningSnapshotCount, int maxAllowedPlanningFailures, String watermarkColumn, TimeUnit watermarkColumnTimeUnit, String branch, String tag, String startTag, String endTag) {
        this.caseSensitive = caseSensitive;
        this.snapshotId = snapshotId;
        this.tag = tag;
        this.branch = branch;
        this.startingStrategy = startingStrategy;
        this.startSnapshotTimestamp = startSnapshotTimestamp;
        this.startSnapshotId = startSnapshotId;
        this.endSnapshotId = endSnapshotId;
        this.asOfTimestamp = asOfTimestamp;
        this.startTag = startTag;
        this.endTag = endTag;
        this.splitSize = splitSize;
        this.splitLookback = splitLookback;
        this.splitOpenFileCost = splitOpenFileCost;
        this.isStreaming = isStreaming;
        this.monitorInterval = monitorInterval;
        this.nameMapping = nameMapping;
        this.schema = schema;
        this.filters = filters;
        this.limit = limit;
        this.includeColumnStats = includeColumnStats;
        this.includeStatsForColumns = includeStatsForColumns;
        this.exposeLocality = exposeLocality;
        this.planParallelism = planParallelism;
        this.maxPlanningSnapshotCount = maxPlanningSnapshotCount;
        this.maxAllowedPlanningFailures = maxAllowedPlanningFailures;
        this.watermarkColumn = watermarkColumn;
        this.watermarkColumnTimeUnit = watermarkColumnTimeUnit;
    }

    void validate() {
        if (this.isStreaming) {
            if (this.startingStrategy == StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID) {
                Preconditions.checkArgument((this.startSnapshotId != null ? 1 : 0) != 0, (Object)"Invalid starting snapshot id for SPECIFIC_START_SNAPSHOT_ID strategy: null");
                Preconditions.checkArgument((this.startSnapshotTimestamp == null ? 1 : 0) != 0, (Object)"Invalid starting snapshot timestamp for SPECIFIC_START_SNAPSHOT_ID strategy: not null");
            }
            if (this.startingStrategy == StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP) {
                Preconditions.checkArgument((this.startSnapshotTimestamp != null ? 1 : 0) != 0, (Object)"Invalid starting snapshot timestamp for SPECIFIC_START_SNAPSHOT_TIMESTAMP strategy: null");
                Preconditions.checkArgument((this.startSnapshotId == null ? 1 : 0) != 0, (Object)"Invalid starting snapshot id for SPECIFIC_START_SNAPSHOT_ID strategy: not null");
            }
            Preconditions.checkArgument((this.tag == null ? 1 : 0) != 0, (Object)String.format("Cannot scan table using ref %s configured for streaming reader", this.tag));
            Preconditions.checkArgument((this.snapshotId == null ? 1 : 0) != 0, (Object)"Cannot set snapshot-id option for streaming reader");
            Preconditions.checkArgument((this.asOfTimestamp == null ? 1 : 0) != 0, (Object)"Cannot set as-of-timestamp option for streaming reader");
            Preconditions.checkArgument((this.endSnapshotId == null ? 1 : 0) != 0, (Object)"Cannot set end-snapshot-id option for streaming reader");
            Preconditions.checkArgument((this.endTag == null ? 1 : 0) != 0, (Object)"Cannot set end-tag option for streaming reader");
        }
        Preconditions.checkArgument((this.startTag == null || this.startSnapshotId() == null ? 1 : 0) != 0, (Object)"START_SNAPSHOT_ID and START_TAG cannot both be set.");
        Preconditions.checkArgument((this.endTag == null || this.endSnapshotId() == null ? 1 : 0) != 0, (Object)"END_SNAPSHOT_ID and END_TAG cannot both be set.");
        Preconditions.checkArgument((this.maxAllowedPlanningFailures >= -1 ? 1 : 0) != 0, (Object)"Cannot set maxAllowedPlanningFailures to a negative number other than -1.");
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public Long snapshotId() {
        return this.snapshotId;
    }

    public String branch() {
        return this.branch;
    }

    public String tag() {
        return this.tag;
    }

    public String startTag() {
        return this.startTag;
    }

    public String endTag() {
        return this.endTag;
    }

    public StreamingStartingStrategy streamingStartingStrategy() {
        return this.startingStrategy;
    }

    public Long startSnapshotTimestamp() {
        return this.startSnapshotTimestamp;
    }

    public Long startSnapshotId() {
        return this.startSnapshotId;
    }

    public Long endSnapshotId() {
        return this.endSnapshotId;
    }

    public Long asOfTimestamp() {
        return this.asOfTimestamp;
    }

    public Long splitSize() {
        return this.splitSize;
    }

    public Integer splitLookback() {
        return this.splitLookback;
    }

    public Long splitOpenFileCost() {
        return this.splitOpenFileCost;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public Duration monitorInterval() {
        return this.monitorInterval;
    }

    public String nameMapping() {
        return this.nameMapping;
    }

    public Schema project() {
        return this.schema;
    }

    public List<Expression> filters() {
        return this.filters;
    }

    public long limit() {
        return this.limit;
    }

    public boolean includeColumnStats() {
        return this.includeColumnStats;
    }

    public Collection<String> includeStatsForColumns() {
        return this.includeStatsForColumns;
    }

    public boolean exposeLocality() {
        return this.exposeLocality;
    }

    public Integer planParallelism() {
        return this.planParallelism;
    }

    public int maxPlanningSnapshotCount() {
        return this.maxPlanningSnapshotCount;
    }

    public int maxAllowedPlanningFailures() {
        return this.maxAllowedPlanningFailures;
    }

    public String watermarkColumn() {
        return this.watermarkColumn;
    }

    public TimeUnit watermarkColumnTimeUnit() {
        return this.watermarkColumnTimeUnit;
    }

    public ScanContext copyWithAppendsBetween(Long newStartSnapshotId, long newEndSnapshotId) {
        return ScanContext.builder().caseSensitive(this.caseSensitive).useSnapshotId(null).useBranch(this.branch).useTag(null).startSnapshotId(newStartSnapshotId).endSnapshotId(newEndSnapshotId).startTag(null).endTag(null).asOfTimestamp(null).splitSize(this.splitSize).splitLookback(this.splitLookback).splitOpenFileCost(this.splitOpenFileCost).streaming(this.isStreaming).monitorInterval(this.monitorInterval).nameMapping(this.nameMapping).project(this.schema).filters(this.filters).limit(this.limit).includeColumnStats(this.includeColumnStats).includeColumnStats(this.includeStatsForColumns).exposeLocality(this.exposeLocality).planParallelism(this.planParallelism).maxPlanningSnapshotCount(this.maxPlanningSnapshotCount).maxAllowedPlanningFailures(this.maxAllowedPlanningFailures).watermarkColumn(this.watermarkColumn).watermarkColumnTimeUnit(this.watermarkColumnTimeUnit).build();
    }

    public ScanContext copyWithSnapshotId(long newSnapshotId) {
        return ScanContext.builder().caseSensitive(this.caseSensitive).useSnapshotId(newSnapshotId).useBranch(this.branch).useTag(this.tag).startSnapshotId(null).endSnapshotId(null).startTag(null).endTag(null).asOfTimestamp(null).splitSize(this.splitSize).splitLookback(this.splitLookback).splitOpenFileCost(this.splitOpenFileCost).streaming(this.isStreaming).monitorInterval(this.monitorInterval).nameMapping(this.nameMapping).project(this.schema).filters(this.filters).limit(this.limit).includeColumnStats(this.includeColumnStats).includeColumnStats(this.includeStatsForColumns).exposeLocality(this.exposeLocality).planParallelism(this.planParallelism).maxPlanningSnapshotCount(this.maxPlanningSnapshotCount).maxAllowedPlanningFailures(this.maxAllowedPlanningFailures).watermarkColumn(this.watermarkColumn).watermarkColumnTimeUnit(this.watermarkColumnTimeUnit).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean caseSensitive = (Boolean)FlinkReadOptions.CASE_SENSITIVE_OPTION.defaultValue();
        private Long snapshotId = (Long)FlinkReadOptions.SNAPSHOT_ID.defaultValue();
        private String branch = (String)FlinkReadOptions.BRANCH.defaultValue();
        private String tag = (String)FlinkReadOptions.TAG.defaultValue();
        private String startTag = (String)FlinkReadOptions.START_TAG.defaultValue();
        private String endTag = (String)FlinkReadOptions.END_TAG.defaultValue();
        private StreamingStartingStrategy startingStrategy = (StreamingStartingStrategy)((Object)FlinkReadOptions.STARTING_STRATEGY_OPTION.defaultValue());
        private Long startSnapshotTimestamp = (Long)FlinkReadOptions.START_SNAPSHOT_TIMESTAMP.defaultValue();
        private Long startSnapshotId = (Long)FlinkReadOptions.START_SNAPSHOT_ID.defaultValue();
        private Long endSnapshotId = (Long)FlinkReadOptions.END_SNAPSHOT_ID.defaultValue();
        private Long asOfTimestamp = (Long)FlinkReadOptions.AS_OF_TIMESTAMP.defaultValue();
        private Long splitSize = (Long)FlinkReadOptions.SPLIT_SIZE_OPTION.defaultValue();
        private Integer splitLookback = (Integer)FlinkReadOptions.SPLIT_LOOKBACK_OPTION.defaultValue();
        private Long splitOpenFileCost = (Long)FlinkReadOptions.SPLIT_FILE_OPEN_COST_OPTION.defaultValue();
        private boolean isStreaming = (Boolean)FlinkReadOptions.STREAMING_OPTION.defaultValue();
        private Duration monitorInterval = TimeUtils.parseDuration((String)((String)FlinkReadOptions.MONITOR_INTERVAL_OPTION.defaultValue()));
        private String nameMapping;
        private Schema projectedSchema;
        private List<Expression> filters;
        private long limit = (Long)FlinkReadOptions.LIMIT_OPTION.defaultValue();
        private boolean includeColumnStats = (Boolean)FlinkReadOptions.INCLUDE_COLUMN_STATS_OPTION.defaultValue();
        private Collection<String> includeStatsForColumns = null;
        private boolean exposeLocality;
        private Integer planParallelism = (Integer)FlinkConfigOptions.TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE.defaultValue();
        private int maxPlanningSnapshotCount = (Integer)FlinkReadOptions.MAX_PLANNING_SNAPSHOT_COUNT_OPTION.defaultValue();
        private int maxAllowedPlanningFailures = (Integer)FlinkReadOptions.MAX_ALLOWED_PLANNING_FAILURES_OPTION.defaultValue();
        private String watermarkColumn = (String)FlinkReadOptions.WATERMARK_COLUMN_OPTION.defaultValue();
        private TimeUnit watermarkColumnTimeUnit = (TimeUnit)((Object)FlinkReadOptions.WATERMARK_COLUMN_TIME_UNIT_OPTION.defaultValue());

        private Builder() {
        }

        public Builder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        public Builder useSnapshotId(Long newSnapshotId) {
            this.snapshotId = newSnapshotId;
            return this;
        }

        public Builder useTag(String newTag) {
            this.tag = newTag;
            return this;
        }

        public Builder useBranch(String newBranch) {
            this.branch = newBranch;
            return this;
        }

        public Builder startingStrategy(StreamingStartingStrategy newStartingStrategy) {
            this.startingStrategy = newStartingStrategy;
            return this;
        }

        public Builder startSnapshotTimestamp(Long newStartSnapshotTimestamp) {
            this.startSnapshotTimestamp = newStartSnapshotTimestamp;
            return this;
        }

        public Builder startSnapshotId(Long newStartSnapshotId) {
            this.startSnapshotId = newStartSnapshotId;
            return this;
        }

        public Builder endSnapshotId(Long newEndSnapshotId) {
            this.endSnapshotId = newEndSnapshotId;
            return this;
        }

        public Builder startTag(String newStartTag) {
            this.startTag = newStartTag;
            return this;
        }

        public Builder endTag(String newEndTag) {
            this.endTag = newEndTag;
            return this;
        }

        public Builder asOfTimestamp(Long newAsOfTimestamp) {
            this.asOfTimestamp = newAsOfTimestamp;
            return this;
        }

        public Builder splitSize(Long newSplitSize) {
            this.splitSize = newSplitSize;
            return this;
        }

        public Builder splitLookback(Integer newSplitLookback) {
            this.splitLookback = newSplitLookback;
            return this;
        }

        public Builder splitOpenFileCost(Long newSplitOpenFileCost) {
            this.splitOpenFileCost = newSplitOpenFileCost;
            return this;
        }

        public Builder streaming(boolean streaming) {
            this.isStreaming = streaming;
            return this;
        }

        public Builder monitorInterval(Duration newMonitorInterval) {
            this.monitorInterval = newMonitorInterval;
            return this;
        }

        public Builder nameMapping(String newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public Builder project(Schema newProjectedSchema) {
            this.projectedSchema = newProjectedSchema;
            return this;
        }

        public Builder filters(List<Expression> newFilters) {
            this.filters = newFilters;
            return this;
        }

        public Builder limit(long newLimit) {
            this.limit = newLimit;
            return this;
        }

        public Builder includeColumnStats(boolean newIncludeColumnStats) {
            this.includeColumnStats = newIncludeColumnStats;
            return this;
        }

        public Builder includeColumnStats(Collection<String> newIncludeStatsForColumns) {
            this.includeStatsForColumns = newIncludeStatsForColumns;
            return this;
        }

        public Builder exposeLocality(boolean newExposeLocality) {
            this.exposeLocality = newExposeLocality;
            return this;
        }

        public Builder planParallelism(Integer parallelism) {
            this.planParallelism = parallelism;
            return this;
        }

        public Builder maxPlanningSnapshotCount(int newMaxPlanningSnapshotCount) {
            this.maxPlanningSnapshotCount = newMaxPlanningSnapshotCount;
            return this;
        }

        public Builder maxAllowedPlanningFailures(int newMaxAllowedPlanningFailures) {
            this.maxAllowedPlanningFailures = newMaxAllowedPlanningFailures;
            return this;
        }

        public Builder watermarkColumn(String newWatermarkColumn) {
            this.watermarkColumn = newWatermarkColumn;
            return this;
        }

        public Builder watermarkColumnTimeUnit(TimeUnit newWatermarkTimeUnit) {
            this.watermarkColumnTimeUnit = newWatermarkTimeUnit;
            return this;
        }

        public Builder resolveConfig(Table table, Map<String, String> readOptions, ReadableConfig readableConfig) {
            FlinkReadConf flinkReadConf = new FlinkReadConf(table, readOptions, readableConfig);
            return this.useSnapshotId(flinkReadConf.snapshotId()).useTag(flinkReadConf.tag()).useBranch(flinkReadConf.branch()).startTag(flinkReadConf.startTag()).endTag(flinkReadConf.endTag()).caseSensitive(flinkReadConf.caseSensitive()).asOfTimestamp(flinkReadConf.asOfTimestamp()).startingStrategy(flinkReadConf.startingStrategy()).startSnapshotTimestamp(flinkReadConf.startSnapshotTimestamp()).startSnapshotId(flinkReadConf.startSnapshotId()).endSnapshotId(flinkReadConf.endSnapshotId()).splitSize(flinkReadConf.splitSize()).splitLookback(flinkReadConf.splitLookback()).splitOpenFileCost(flinkReadConf.splitFileOpenCost()).streaming(flinkReadConf.streaming()).monitorInterval(flinkReadConf.monitorInterval()).nameMapping(flinkReadConf.nameMapping()).limit(flinkReadConf.limit()).planParallelism(flinkReadConf.workerPoolSize()).includeColumnStats(flinkReadConf.includeColumnStats()).maxPlanningSnapshotCount(flinkReadConf.maxPlanningSnapshotCount()).maxAllowedPlanningFailures(flinkReadConf.maxAllowedPlanningFailures()).watermarkColumn(flinkReadConf.watermarkColumn()).watermarkColumnTimeUnit(flinkReadConf.watermarkColumnTimeUnit());
        }

        public ScanContext build() {
            return new ScanContext(this.caseSensitive, this.snapshotId, this.startingStrategy, this.startSnapshotTimestamp, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.isStreaming, this.monitorInterval, this.nameMapping, this.projectedSchema, this.filters, this.limit, this.includeColumnStats, this.includeStatsForColumns, this.exposeLocality, this.planParallelism, this.maxPlanningSnapshotCount, this.maxAllowedPlanningFailures, this.watermarkColumn, this.watermarkColumnTimeUnit, this.branch, this.tag, this.startTag, this.endTag);
        }
    }
}

