/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.encryption.InputFilesDecryptor;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.flink.source.RowDataFileScanTaskReader;
import org.apache.iceberg.flink.source.reader.DataIteratorReaderFunction;
import org.apache.iceberg.flink.source.reader.LimitableDataIterator;
import org.apache.iceberg.flink.source.reader.ListDataIteratorBatcher;
import org.apache.iceberg.flink.source.reader.RecordLimiter;
import org.apache.iceberg.flink.source.reader.RowDataConverter;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

@Internal
public class ConverterReaderFunction<T>
extends DataIteratorReaderFunction<T> {
    private final RowDataConverter<T> converter;
    private final Schema tableSchema;
    private final Schema readSchema;
    private final String nameMapping;
    private final boolean caseSensitive;
    private final FileIO io;
    private final EncryptionManager encryption;
    private final List<Expression> filters;
    private final long limit;
    private transient RecordLimiter recordLimiter = null;

    public ConverterReaderFunction(RowDataConverter<T> converter, ReadableConfig config, Schema tableSchema, Schema projectedSchema, String nameMapping, boolean caseSensitive, FileIO io, EncryptionManager encryption, List<Expression> filters, long limit) {
        super(new ListDataIteratorBatcher(config));
        this.converter = converter;
        this.tableSchema = tableSchema;
        this.readSchema = ConverterReaderFunction.readSchema(tableSchema, projectedSchema);
        this.nameMapping = nameMapping;
        this.caseSensitive = caseSensitive;
        this.io = io;
        this.encryption = encryption;
        this.filters = filters;
        this.limit = limit;
    }

    @Override
    protected DataIterator<T> createDataIterator(IcebergSourceSplit split) {
        RowDataFileScanTaskReader rowDataReader = new RowDataFileScanTaskReader(this.tableSchema, this.readSchema, this.nameMapping, this.caseSensitive, this.filters);
        return new LimitableDataIterator<T>(new ConverterFileScanTaskReader<T>(rowDataReader, this.converter), split.task(), this.io, this.encryption, this.lazyLimiter());
    }

    private static Schema readSchema(Schema tableSchema, Schema projectedSchema) {
        Preconditions.checkNotNull((Object)tableSchema, (Object)"Table schema can't be null");
        return projectedSchema == null ? tableSchema : projectedSchema;
    }

    private RecordLimiter lazyLimiter() {
        if (this.recordLimiter == null) {
            this.recordLimiter = RecordLimiter.create(this.limit);
        }
        return this.recordLimiter;
    }

    private static class ConverterFileScanTaskReader<T>
    implements FileScanTaskReader<T> {
        private final RowDataFileScanTaskReader rowDataReader;
        private final RowDataConverter<T> converter;

        ConverterFileScanTaskReader(RowDataFileScanTaskReader rowDataReader, RowDataConverter<T> converter) {
            this.rowDataReader = rowDataReader;
            this.converter = converter;
        }

        @Override
        public CloseableIterator<T> open(FileScanTask fileScanTask, InputFilesDecryptor inputFilesDecryptor) {
            return CloseableIterator.transform(this.rowDataReader.open(fileScanTask, inputFilesDecryptor), this.converter);
        }
    }
}

