/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Locale;
import org.apache.flink.annotation.Internal;

@Internal
public class RecordAndPosition<T> {
    private T record;
    private int fileOffset;
    private long recordOffset;

    public RecordAndPosition(T record, int fileOffset, long recordOffset) {
        this.record = record;
        this.fileOffset = fileOffset;
        this.recordOffset = recordOffset;
    }

    public RecordAndPosition() {
    }

    public T record() {
        return this.record;
    }

    public int fileOffset() {
        return this.fileOffset;
    }

    public long recordOffset() {
        return this.recordOffset;
    }

    public void set(T newRecord, int newFileOffset, long newRecordOffset) {
        this.record = newRecord;
        this.fileOffset = newFileOffset;
        this.recordOffset = newRecordOffset;
    }

    public void record(T nextRecord) {
        this.record = nextRecord;
        ++this.recordOffset;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s @ %d + %d", this.record, this.fileOffset, this.recordOffset);
    }
}

