/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;

public interface MetadataUpdate
extends Serializable {

    public static class SetLocation
    implements MetadataUpdate {
        private final String location;

        public SetLocation(String location) {
            this.location = location;
        }

        public String location() {
            return this.location;
        }
    }

    public static class RemoveProperties
    implements MetadataUpdate {
        private final Set<String> removed;

        public RemoveProperties(Set<String> removed) {
            this.removed = removed;
        }

        public Set<String> removed() {
            return this.removed;
        }
    }

    public static class SetProperties
    implements MetadataUpdate {
        private final Map<String, String> updated;

        public SetProperties(Map<String, String> updated) {
            this.updated = updated;
        }

        public Map<String, String> updated() {
            return this.updated;
        }
    }

    public static class SetCurrentSnapshot
    implements MetadataUpdate {
        private final Long snapshotId;

        public SetCurrentSnapshot(Long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public Long snapshotId() {
            return this.snapshotId;
        }
    }

    public static class RemoveSnapshot
    implements MetadataUpdate {
        private final long snapshotId;

        public RemoveSnapshot(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long snapshotId() {
            return this.snapshotId;
        }
    }

    public static class AddSnapshot
    implements MetadataUpdate {
        private final Snapshot snapshot;

        public AddSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }
    }

    public static class SetDefaultSortOrder
    implements MetadataUpdate {
        private final int sortOrderId;

        public SetDefaultSortOrder(int sortOrderId) {
            this.sortOrderId = sortOrderId;
        }

        public int sortOrderId() {
            return this.sortOrderId;
        }
    }

    public static class AddSortOrder
    implements MetadataUpdate {
        private final SortOrder sortOrder;

        public AddSortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        public SortOrder spec() {
            return this.sortOrder;
        }
    }

    public static class SetDefaultPartitionSpec
    implements MetadataUpdate {
        private final int specId;

        public SetDefaultPartitionSpec(int schemaId) {
            this.specId = schemaId;
        }

        public int specId() {
            return this.specId;
        }
    }

    public static class AddPartitionSpec
    implements MetadataUpdate {
        private final PartitionSpec spec;

        public AddPartitionSpec(PartitionSpec spec) {
            this.spec = spec;
        }

        public PartitionSpec spec() {
            return this.spec;
        }
    }

    public static class SetCurrentSchema
    implements MetadataUpdate {
        private final int schemaId;

        public SetCurrentSchema(int schemaId) {
            this.schemaId = schemaId;
        }

        public int schemaId() {
            return this.schemaId;
        }
    }

    public static class AddSchema
    implements MetadataUpdate {
        private final Schema schema;
        private final int lastColumnId;

        public AddSchema(Schema schema, int lastColumnId) {
            this.schema = schema;
            this.lastColumnId = lastColumnId;
        }

        public Schema schema() {
            return this.schema;
        }

        public int lastColumnId() {
            return this.lastColumnId;
        }
    }

    public static class UpgradeFormatVersion
    implements MetadataUpdate {
        private final int formatVersion;

        public UpgradeFormatVersion(int formatVersion) {
            this.formatVersion = formatVersion;
        }

        public int formatVersion() {
            return this.formatVersion;
        }
    }

    public static class AssignUUID
    implements MetadataUpdate {
        private final String uuid;

        public AssignUUID(String uuid) {
            this.uuid = uuid;
        }

        public String uuid() {
            return this.uuid;
        }
    }
}

