/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;

public class SnapshotsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_SCHEMA = new Schema(Types.NestedField.required(1, "committed_at", Types.TimestampType.withZone()), Types.NestedField.required(2, "snapshot_id", Types.LongType.get()), Types.NestedField.optional(3, "parent_id", Types.LongType.get()), Types.NestedField.optional(4, "operation", Types.StringType.get()), Types.NestedField.optional(5, "manifest_list", Types.StringType.get()), Types.NestedField.optional(6, "summary", Types.MapType.ofRequired(7, 8, Types.StringType.get(), Types.StringType.get())));

    SnapshotsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".snapshots");
    }

    SnapshotsTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    @Override
    public TableScan newScan() {
        return new SnapshotsTableScan(this.operations(), this.table());
    }

    @Override
    public Schema schema() {
        return SNAPSHOT_SCHEMA;
    }

    private DataTask task(BaseTableScan scan) {
        TableOperations ops = this.operations();
        return StaticDataTask.of(ops.io().newInputFile(ops.current().metadataFileLocation()), this.schema(), scan.schema(), ops.current().snapshots(), SnapshotsTable::snapshotToRow);
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.SNAPSHOTS;
    }

    private static StaticDataTask.Row snapshotToRow(Snapshot snap) {
        return StaticDataTask.Row.of(snap.timestampMillis() * 1000L, snap.snapshotId(), snap.parentId(), snap.operation(), snap.manifestListLocation(), snap.summary());
    }

    private class SnapshotsTableScan
    extends StaticTableScan {
        SnapshotsTableScan(TableOperations ops, Table table) {
            super(ops, table, SNAPSHOT_SCHEMA, SnapshotsTable.this.metadataTableType().name(), x$0 -> SnapshotsTable.this.task(x$0));
        }

        SnapshotsTableScan(TableOperations ops, Table table, TableScanContext context) {
            super(ops, table, SNAPSHOT_SCHEMA, SnapshotsTable.this.metadataTableType().name(), x$0 -> SnapshotsTable.this.task(x$0), context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new SnapshotsTableScan(ops, table, context);
        }

        @Override
        public CloseableIterable<FileScanTask> planFiles() {
            return CloseableIterable.withNoopClose(SnapshotsTable.this.task(this));
        }
    }
}

