/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun.oss;

import com.aliyun.oss.OSS;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.aliyun.AliyunClientFactories;
import org.apache.iceberg.aliyun.AliyunClientFactory;
import org.apache.iceberg.aliyun.AliyunProperties;
import org.apache.iceberg.aliyun.oss.OSSInputFile;
import org.apache.iceberg.aliyun.oss.OSSOutputFile;
import org.apache.iceberg.aliyun.oss.OSSURI;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.util.SerializableSupplier;

public class OSSFileIO
implements FileIO {
    private SerializableSupplier<OSS> oss;
    private AliyunProperties aliyunProperties;
    private transient OSS client;
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);

    public OSSFileIO() {
    }

    public OSSFileIO(SerializableSupplier<OSS> oss) {
        this.oss = oss;
        this.aliyunProperties = new AliyunProperties();
    }

    @Override
    public InputFile newInputFile(String path) {
        return new OSSInputFile(this.client(), new OSSURI(path), this.aliyunProperties);
    }

    @Override
    public OutputFile newOutputFile(String path) {
        return new OSSOutputFile(this.client(), new OSSURI(path), this.aliyunProperties);
    }

    @Override
    public void deleteFile(String path) {
        OSSURI location = new OSSURI(path);
        this.client().deleteObject(location.bucket(), location.key());
    }

    private OSS client() {
        if (this.client == null) {
            this.client = (OSS)this.oss.get();
        }
        return this.client;
    }

    @Override
    public void initialize(Map<String, String> properties) {
        AliyunClientFactory factory = AliyunClientFactories.from(properties);
        this.aliyunProperties = factory.aliyunProperties();
        this.oss = factory::newOSSClient;
    }

    @Override
    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true) && this.client != null) {
            this.client.shutdown();
        }
    }
}

