/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieTableOperations;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.nessie.UpdateableReference;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.Tasks;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.TableReference;
import org.projectnessie.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieCatalog
extends BaseMetastoreCatalog
implements AutoCloseable,
SupportsNamespaces,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(NessieCatalog.class);
    private static final Joiner SLASH = Joiner.on("/");
    private NessieApiV1 api;
    private String warehouseLocation;
    private Configuration config;
    private UpdateableReference reference;
    private String name;
    private FileIO fileIO;
    private Map<String, String> catalogOptions;

    @Override
    public void initialize(String inputName, Map<String, String> options) {
        this.catalogOptions = ImmutableMap.copyOf(options);
        String fileIOImpl = options.get("io-impl");
        this.fileIO = fileIOImpl == null ? new HadoopFileIO(this.config) : CatalogUtil.loadFileIO(fileIOImpl, options, this.config);
        this.name = inputName == null ? "nessie" : inputName;
        Function<String, String> removePrefix = x -> x.replace("nessie.", "");
        this.api = NessieCatalog.createNessieClientBuilder(options.get("nessie.client-builder-impl")).fromConfig(x -> (String)options.get(removePrefix.apply((String)x))).build(NessieApiV1.class);
        this.warehouseLocation = options.get("warehouse");
        if (this.warehouseLocation == null) {
            logger.warn("Catalog creation for inputName={} and options {} failed, because parameter 'warehouse' is not set, Nessie can't store data.", (Object)inputName, options);
            throw new IllegalStateException("Parameter 'warehouse' not set, Nessie can't store data.");
        }
        String requestedRef = options.get(removePrefix.apply("nessie.ref"));
        this.reference = this.loadReference(requestedRef, null);
    }

    private static NessieClientBuilder<?> createNessieClientBuilder(String customBuilder) {
        NessieClientBuilder<HttpClientBuilder> clientBuilder;
        if (customBuilder != null) {
            try {
                clientBuilder = (NessieClientBuilder)DynMethods.builder("builder").impl(customBuilder, new Class[0]).build().asStatic().invoke(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to use custom NessieClientBuilder '%s'.", customBuilder), e);
            }
        } else {
            clientBuilder = HttpClientBuilder.builder();
        }
        return clientBuilder;
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        TableReference tr = TableReference.parse(tableIdentifier.name());
        Preconditions.checkArgument(!tr.hasTimestamp(), "Invalid table name: # is only allowed for hashes (reference by timestamp is not supported)");
        UpdateableReference newReference = this.reference;
        if (tr.getReference() != null) {
            newReference = this.loadReference(tr.getReference(), tr.getHash());
        }
        return new NessieTableOperations(ContentKey.of(org.projectnessie.model.Namespace.of(tableIdentifier.namespace().levels()), tr.getName()), newReference, this.api, this.fileIO, this.catalogOptions);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier table) {
        if (table.hasNamespace()) {
            return SLASH.join(this.warehouseLocation, table.namespace().toString(), table.name());
        }
        return SLASH.join(this.warehouseLocation, table.name(), new Object[0]);
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        return this.tableStream(namespace).collect(Collectors.toList());
    }

    @Override
    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        this.reference.checkMutable();
        IcebergTable existingTable = this.table(identifier);
        if (existingTable == null) {
            return false;
        }
        if (purge) {
            logger.info("Purging data for table {} was set to true but is ignored", (Object)identifier.toString());
        }
        CommitMultipleOperationsBuilder commitBuilderBase = this.api.commitMultipleOperations().commitMeta(NessieUtil.buildCommitMetadata(String.format("Iceberg delete table %s", identifier), this.catalogOptions)).operation(Operation.Delete.of(NessieUtil.toKey(identifier)));
        boolean threw = true;
        try {
            Tasks.foreach(commitBuilderBase).retry(5).stopRetryOn(NessieNotFoundException.class).throwFailureWhenFinished().onFailure((o, exception) -> this.refresh()).run(commitBuilder -> {
                Branch branch = ((CommitMultipleOperationsBuilder)commitBuilder.branch(this.reference.getAsBranch())).commit();
                this.reference.updateReference(branch);
            }, BaseNessieClientServerException.class);
            threw = false;
        }
        catch (NessieConflictException e) {
            logger.error("Cannot drop table: failed after retry (update ref and retry)", (Throwable)e);
        }
        catch (NessieNotFoundException e) {
            logger.error("Cannot drop table: ref is no longer valid.", (Throwable)e);
        }
        catch (BaseNessieClientServerException e) {
            logger.error("Cannot drop table: unknown error", (Throwable)e);
        }
        return !threw;
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier toOriginal) {
        this.reference.checkMutable();
        TableIdentifier to = NessieUtil.removeCatalogName(toOriginal, this.name());
        IcebergTable existingFromTable = this.table(from);
        if (existingFromTable == null) {
            throw new NoSuchTableException("table %s doesn't exists", from.name());
        }
        IcebergTable existingToTable = this.table(to);
        if (existingToTable != null) {
            throw new AlreadyExistsException("table %s already exists", to.name());
        }
        CommitMultipleOperationsBuilder operations = this.api.commitMultipleOperations().commitMeta(NessieUtil.buildCommitMetadata(String.format("Iceberg rename table from '%s' to '%s'", from, to), this.catalogOptions)).operation(Operation.Put.of(NessieUtil.toKey(to), existingFromTable, existingFromTable)).operation(Operation.Delete.of(NessieUtil.toKey(from)));
        try {
            Tasks.foreach(operations).retry(5).stopRetryOn(NessieNotFoundException.class).throwFailureWhenFinished().onFailure((o, exception) -> this.refresh()).run(ops -> {
                Branch branch = ((CommitMultipleOperationsBuilder)ops.branch(this.reference.getAsBranch())).commit();
                this.reference.updateReference(branch);
            }, BaseNessieClientServerException.class);
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException("Failed to drop table as ref is no longer valid.", e);
        }
        catch (BaseNessieClientServerException e) {
            throw new CommitFailedException(e, "Failed to rename table: the current reference is not up to date.", new Object[0]);
        }
        catch (HttpClientException ex) {
            throw new CommitStateUnknownException(ex);
        }
    }

    @Override
    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
    }

    @Override
    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        return this.tableStream(namespace).map(TableIdentifier::namespace).filter(n -> !n.isEmpty()).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        return ImmutableMap.of();
    }

    @Override
    public boolean dropNamespace(Namespace namespace) {
        throw new UnsupportedOperationException("Cannot drop namespace '" + namespace + "': dropNamespace is not supported by the NessieCatalog");
    }

    @Override
    public boolean setProperties(Namespace namespace, Map<String, String> properties) {
        throw new UnsupportedOperationException("Cannot set properties for namespace '" + namespace + "': setProperties is not supported by the NessieCatalog");
    }

    @Override
    public boolean removeProperties(Namespace namespace, Set<String> properties) {
        throw new UnsupportedOperationException("Cannot remove properties for namespace '" + namespace + "': removeProperties is not supported by the NessieCatalog");
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }

    public void refresh() throws NessieNotFoundException {
        this.reference.refresh(this.api);
    }

    public String currentHash() {
        return this.reference.getHash();
    }

    @VisibleForTesting
    String currentRefName() {
        return this.reference.getName();
    }

    @VisibleForTesting
    FileIO fileIO() {
        return this.fileIO;
    }

    private IcebergTable table(TableIdentifier tableIdentifier) {
        try {
            ContentKey key = NessieUtil.toKey(tableIdentifier);
            Content table = ((GetContentBuilder)this.api.getContent().key(key).reference(this.reference.getReference())).get().get(key);
            return table != null ? (IcebergTable)table.unwrap(IcebergTable.class).orElse(null) : null;
        }
        catch (NessieNotFoundException e) {
            return null;
        }
    }

    private UpdateableReference loadReference(String requestedRef, String hash) {
        try {
            Reference ref;
            Reference reference = ref = requestedRef == null ? this.api.getDefaultBranch() : this.api.getReference().refName(requestedRef).get();
            if (hash != null) {
                ref = ref instanceof Branch ? Branch.of(ref.getName(), hash) : Tag.of(ref.getName(), hash);
            }
            return new UpdateableReference(ref, hash != null);
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(String.format("Nessie ref '%s' does not exist. This ref must exist before creating a NessieCatalog.", requestedRef), ex);
            }
            throw new IllegalArgumentException(String.format("Nessie does not have an existing default branch.Either configure an alternative ref via %s or create the default branch on the server.", "nessie.ref"), ex);
        }
    }

    private Stream<TableIdentifier> tableStream(Namespace namespace) {
        try {
            return ((GetEntriesBuilder)this.api.getEntries().reference(this.reference.getReference())).get().getEntries().stream().filter(NessieUtil.namespacePredicate(namespace)).map(NessieUtil::toIdentifier);
        }
        catch (NessieNotFoundException ex) {
            throw new NoSuchNamespaceException(ex, "Unable to list tables due to missing ref. %s", this.reference.getName());
        }
    }
}

