/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableCommitMeta;

public final class NessieUtil {
    public static final String NESSIE_CONFIG_PREFIX = "nessie.";
    public static final String CONFIG_CLIENT_BUILDER_IMPL = "nessie.client-builder-impl";
    static final String APPLICATION_TYPE = "application-type";

    private NessieUtil() {
    }

    static Predicate<EntriesResponse.Entry> namespacePredicate(Namespace ns) {
        if (ns == null) {
            return e -> true;
        }
        List<String> namespace = Arrays.asList(ns.levels());
        Predicate<EntriesResponse.Entry> predicate = e -> {
            List<String> names = e.getName().getElements();
            if (names.size() <= namespace.size()) {
                return false;
            }
            return namespace.equals(names.subList(0, namespace.size()));
        };
        return predicate;
    }

    static TableIdentifier toIdentifier(EntriesResponse.Entry entry) {
        List<String> elements = entry.getName().getElements();
        return TableIdentifier.of(elements.toArray(new String[elements.size()]));
    }

    static TableIdentifier removeCatalogName(TableIdentifier to, String name) {
        String[] levels = to.namespace().levels();
        if (levels.length >= 2 && name.equalsIgnoreCase(to.namespace().level(0))) {
            Namespace trimmedNamespace = Namespace.of(Arrays.copyOfRange(levels, 1, levels.length));
            return TableIdentifier.of(trimmedNamespace, to.name());
        }
        return to;
    }

    static ContentKey toKey(TableIdentifier tableIdentifier) {
        ArrayList<String> identifiers = Lists.newArrayList();
        if (tableIdentifier.hasNamespace()) {
            identifiers.addAll(Arrays.asList(tableIdentifier.namespace().levels()));
        }
        identifiers.add(tableIdentifier.name());
        return ContentKey.of(identifiers);
    }

    static CommitMeta buildCommitMetadata(String commitMsg, Map<String, String> catalogOptions) {
        return NessieUtil.catalogOptions(CommitMeta.builder().message(commitMsg), catalogOptions).build();
    }

    static ImmutableCommitMeta.Builder catalogOptions(ImmutableCommitMeta.Builder commitMetaBuilder, Map<String, String> catalogOptions) {
        Preconditions.checkArgument(null != catalogOptions, "catalogOptions must not be null");
        commitMetaBuilder.author(NessieUtil.commitAuthor(catalogOptions));
        commitMetaBuilder.putProperties(APPLICATION_TYPE, "iceberg");
        if (catalogOptions.containsKey("app-id")) {
            commitMetaBuilder.putProperties("app-id", catalogOptions.get("app-id"));
        }
        return commitMetaBuilder;
    }

    @Nullable
    private static String commitAuthor(Map<String, String> catalogOptions) {
        return Optional.ofNullable(catalogOptions.get("user")).orElseGet(() -> System.getProperty("user.name"));
    }
}

