/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl.filter.leaf;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.shaded.org.apache.orc.impl.filter.LeafFilter;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.serde2.io.HiveDecimalWritable;

class DecimalFilters {
    private DecimalFilters() {
    }

    static class DecimalLessThanEquals
    extends LeafFilter {
        private final HiveDecimalWritable aValue;

        DecimalLessThanEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (HiveDecimalWritable)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DecimalColumnVector)v).vector[rowIdx].compareTo(this.aValue) <= 0;
        }
    }

    static class DecimalLessThan
    extends LeafFilter {
        private final HiveDecimalWritable aValue;

        DecimalLessThan(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (HiveDecimalWritable)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DecimalColumnVector)v).vector[rowIdx].compareTo(this.aValue) < 0;
        }
    }

    static class DecimalIn
    extends LeafFilter {
        private final Set<HiveDecimalWritable> inValues;

        DecimalIn(String colName, List<Object> values, boolean negated) {
            super(colName, negated);
            this.inValues = new HashSet<HiveDecimalWritable>(values.size());
            for (Object value : values) {
                this.inValues.add((HiveDecimalWritable)value);
            }
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return this.inValues.contains(((DecimalColumnVector)v).vector[rowIdx]);
        }
    }

    static class DecimalEquals
    extends LeafFilter {
        private final HiveDecimalWritable aValue;

        DecimalEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (HiveDecimalWritable)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DecimalColumnVector)v).vector[rowIdx].compareTo(this.aValue) == 0;
        }
    }

    static class DecimalBetween
    extends LeafFilter {
        private final HiveDecimalWritable low;
        private final HiveDecimalWritable high;

        DecimalBetween(String colName, Object low, Object high, boolean negated) {
            super(colName, negated);
            this.low = (HiveDecimalWritable)low;
            this.high = (HiveDecimalWritable)high;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DecimalColumnVector)v).vector[rowIdx].compareTo(this.low) >= 0 && ((DecimalColumnVector)v).vector[rowIdx].compareTo(this.high) <= 0;
        }
    }
}

