/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpClientReadTimeoutException;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.ResponseContextImpl;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.http.UriBuilder;

public class HttpRequest {
    public static final String HEADER_ACCEPT = "Accept";
    private final UriBuilder uriBuilder;
    private final ObjectMapper mapper;
    private final int readTimeoutMillis;
    private final int connectionTimeoutMillis;
    private final Map<String, Set<String>> headers = new HashMap<String, Set<String>>();
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;
    private SSLContext sslContext;
    private String contentsType = "application/json; charset=utf-8";
    private String accept = "application/json; charset=utf-8";

    HttpRequest(URI baseUri, ObjectMapper mapper, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, SSLContext context, int readTimeoutMillis, int connectionTimeoutMillis) {
        this.uriBuilder = new UriBuilder(baseUri);
        this.mapper = mapper;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.sslContext = context;
    }

    static void putHeader(String key, String value, Map<String, Set<String>> headers) {
        if (!headers.containsKey(key)) {
            headers.put(key, new HashSet());
        }
        headers.get(key).add(value);
    }

    public HttpRequest contentsType(String contentsType) {
        this.contentsType = contentsType;
        return this;
    }

    public HttpRequest accept(String contentsType) {
        this.accept = contentsType;
        return this;
    }

    public HttpRequest path(String path) {
        this.uriBuilder.path(path);
        return this;
    }

    public HttpRequest queryParam(String name, String value) {
        this.uriBuilder.queryParam(name, value);
        return this;
    }

    public HttpRequest header(String name, String value) {
        HttpRequest.putHeader(name, value, this.headers);
        return this;
    }

    private HttpResponse executeRequest(HttpClient.Method method, Object body) throws HttpClientException {
        try {
            URI uri = this.uriBuilder.build();
            HttpURLConnection con = (HttpURLConnection)uri.toURL().openConnection();
            con.setReadTimeout(this.readTimeoutMillis);
            con.setConnectTimeout(this.connectionTimeoutMillis);
            if (con instanceof HttpsURLConnection) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.sslContext.getSocketFactory());
            }
            RequestContext context = new RequestContext(this.headers, uri, method, body);
            ResponseContextImpl responseContext = new ResponseContextImpl(con);
            try {
                HttpRequest.putHeader(HEADER_ACCEPT, this.accept, this.headers);
                this.requestFilters.forEach(a -> a.filter(context));
                this.headers.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(x -> new AbstractMap.SimpleImmutableEntry<String, String>((String)e.getKey(), (String)x))).forEach(x -> con.setRequestProperty((String)x.getKey(), (String)x.getValue()));
                con.setRequestMethod(method.name());
                if (method.equals((Object)HttpClient.Method.PUT) || method.equals((Object)HttpClient.Method.POST)) {
                    con.setRequestProperty("Content-Type", this.contentsType);
                    if (body != null) {
                        con.setDoOutput(true);
                        Class<?> bodyType = body.getClass();
                        if (bodyType != String.class) {
                            this.mapper.writerFor(bodyType).writeValue(con.getOutputStream(), body);
                        } else {
                            con.getOutputStream().write(((String)body).getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
                con.connect();
                con.getResponseCode();
                List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
                if (callbacks != null) {
                    callbacks.forEach(callback -> callback.accept(responseContext, null));
                }
            }
            catch (IOException e2) {
                List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
                if (callbacks != null) {
                    callbacks.forEach(callback -> callback.accept(null, e2));
                }
                throw e2;
            }
            this.responseFilters.forEach(responseFilter -> responseFilter.filter(responseContext));
            return new HttpResponse(responseContext, this.mapper);
        }
        catch (ProtocolException e3) {
            throw new HttpClientException(String.format("Cannot perform request. Invalid protocol %s", new Object[]{method}), e3);
        }
        catch (JsonGenerationException | JsonMappingException e4) {
            throw new HttpClientException(String.format("Cannot serialize body of request. Unable to serialize %s", body.getClass()), e4);
        }
        catch (MalformedURLException e5) {
            throw new HttpClientException(String.format("Cannot perform request. Malformed Url for %s", this.uriBuilder.build()), e5);
        }
        catch (SocketTimeoutException e6) {
            throw new HttpClientReadTimeoutException(String.format("Cannot finish request. Timeout while waiting for response with a timeout of %ds", this.readTimeoutMillis / 1000), e6);
        }
        catch (IOException e7) {
            throw new HttpClientException(e7);
        }
    }

    public HttpRequest setSslContext(SSLContext context) {
        this.sslContext = context;
        return this;
    }

    public HttpResponse get() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.GET, null);
    }

    public HttpResponse delete() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.DELETE, null);
    }

    public HttpResponse post(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.POST, obj);
    }

    public HttpResponse put(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.PUT, obj);
    }

    public HttpRequest resolveTemplate(String name, String value) {
        this.uriBuilder.resolveTemplate(name, value);
        return this;
    }
}

