/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.ResponseContext;

public class RequestContext {
    private final Map<String, Set<String>> headers;
    private final URI uri;
    private final HttpClient.Method method;
    private final Object body;
    private List<BiConsumer<ResponseContext, Exception>> responseCallbacks;

    public RequestContext(Map<String, Set<String>> headers, URI uri, HttpClient.Method method, Object body) {
        this.headers = headers;
        this.uri = uri;
        this.method = method;
        this.body = body;
    }

    public Map<String, Set<String>> getHeaders() {
        return this.headers;
    }

    public void putHeader(String name, String value) {
        HttpRequest.putHeader(name, value, this.headers);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpClient.Method getMethod() {
        return this.method;
    }

    public Optional<Object> getBody() {
        return this.body == null ? Optional.empty() : Optional.of(this.body);
    }

    public void addResponseCallback(BiConsumer<ResponseContext, Exception> responseCallback) {
        if (this.responseCallbacks == null) {
            this.responseCallbacks = new ArrayList<BiConsumer<ResponseContext, Exception>>();
        }
        this.responseCallbacks.add(responseCallback);
    }

    List<BiConsumer<ResponseContext, Exception>> getResponseCallbacks() {
        return this.responseCallbacks;
    }
}

