/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Merge Operation", properties={@SchemaProperty(name="fromRefName", pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$"), @SchemaProperty(name="fromHash", pattern="^[0-9a-fA-F]{16,64}$")})
@JsonSerialize(as=ImmutableMerge.class)
@JsonDeserialize(as=ImmutableMerge.class)
@Value.Immutable
public interface Merge {
    @NotBlank
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    public @NotBlank @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String getFromHash();

    @NotBlank
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..")
    public @NotBlank @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String getFromRefName();

    @Value.Check
    default public void checkHash() {
        String hash = this.getFromHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }
}

