/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.Base;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Reference", oneOf={Branch.class, Tag.class}, discriminatorMapping={@DiscriminatorMapping(value="TAG", schema=Tag.class), @DiscriminatorMapping(value="BRANCH", schema=Branch.class)}, discriminatorProperty="type", properties={@SchemaProperty(name="name", pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$"), @SchemaProperty(name="hash", pattern="^[0-9a-fA-F]{16,64}$"), @SchemaProperty(name="metadata", nullable=true)})
@JsonSubTypes(value={@JsonSubTypes.Type(value=Branch.class), @JsonSubTypes.Type(value=Tag.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
public interface Reference
extends Base {
    @NotBlank
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..")
    public @NotBlank @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String getName();

    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    public @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String getHash();

    @Value.Check
    default public void checkHash() {
        String hash = this.getHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ReferenceMetadata getMetadata();
}

