/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ImmutableSqlView;

@JsonSerialize(as=ImmutableSqlView.class)
@JsonDeserialize(as=ImmutableSqlView.class)
@JsonTypeName(value="VIEW")
@Value.Immutable
public abstract class SqlView
extends Content {
    @NotBlank
    public abstract String getSqlText();

    @NotNull
    public abstract Dialect getDialect();

    @Override
    public Content.Type getType() {
        return Content.Type.VIEW;
    }

    public static SqlView of(Dialect dialect, String sqlText) {
        return ImmutableSqlView.builder().dialect(dialect).sqlText(sqlText).build();
    }

    public static enum Dialect {
        HIVE,
        SPARK,
        DREMIO,
        PRESTO;

    }
}

