/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import org.apache.iceberg.AllDataFilesTable;
import org.apache.iceberg.AllDeleteFilesTable;
import org.apache.iceberg.AllEntriesTable;
import org.apache.iceberg.AllFilesTable;
import org.apache.iceberg.AllManifestsTable;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.DeleteFilesTable;
import org.apache.iceberg.FilesTable;
import org.apache.iceberg.HistoryTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.SnapshotsTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;

public class MetadataTableUtils {
    private MetadataTableUtils() {
    }

    public static boolean hasMetadataTableName(TableIdentifier identifier) {
        return MetadataTableType.from(identifier.name()) != null;
    }

    public static Table createMetadataTableInstance(Table table, MetadataTableType type) {
        if (table instanceof BaseTable) {
            TableOperations ops = ((BaseTable)table).operations();
            return MetadataTableUtils.createMetadataTableInstance(ops, table, MetadataTableUtils.metadataTableName(table.name(), type), type);
        }
        throw new IllegalArgumentException(String.format("Cannot create metadata table for table %s: not a base table", table));
    }

    public static Table createMetadataTableInstance(TableOperations ops, String baseTableName, String metadataTableName, MetadataTableType type) {
        BaseTable baseTable = new BaseTable(ops, baseTableName);
        return MetadataTableUtils.createMetadataTableInstance(ops, baseTable, metadataTableName, type);
    }

    private static Table createMetadataTableInstance(TableOperations ops, Table baseTable, String metadataTableName, MetadataTableType type) {
        switch (type) {
            case ENTRIES: {
                return new ManifestEntriesTable(ops, baseTable, metadataTableName);
            }
            case FILES: {
                return new FilesTable(ops, baseTable, metadataTableName);
            }
            case DATA_FILES: {
                return new DataFilesTable(ops, baseTable, metadataTableName);
            }
            case DELETE_FILES: {
                return new DeleteFilesTable(ops, baseTable, metadataTableName);
            }
            case HISTORY: {
                return new HistoryTable(ops, baseTable, metadataTableName);
            }
            case SNAPSHOTS: {
                return new SnapshotsTable(ops, baseTable, metadataTableName);
            }
            case MANIFESTS: {
                return new ManifestsTable(ops, baseTable, metadataTableName);
            }
            case PARTITIONS: {
                return new PartitionsTable(ops, baseTable, metadataTableName);
            }
            case ALL_DATA_FILES: {
                return new AllDataFilesTable(ops, baseTable, metadataTableName);
            }
            case ALL_DELETE_FILES: {
                return new AllDeleteFilesTable(ops, baseTable, metadataTableName);
            }
            case ALL_FILES: {
                return new AllFilesTable(ops, baseTable, metadataTableName);
            }
            case ALL_MANIFESTS: {
                return new AllManifestsTable(ops, baseTable, metadataTableName);
            }
            case ALL_ENTRIES: {
                return new AllEntriesTable(ops, baseTable, metadataTableName);
            }
        }
        throw new NoSuchTableException("Unknown metadata table type: %s for %s", new Object[]{type, metadataTableName});
    }

    public static Table createMetadataTableInstance(TableOperations ops, String catalogName, TableIdentifier baseTableIdentifier, TableIdentifier metadataTableIdentifier, MetadataTableType type) {
        String baseTableName = BaseMetastoreCatalog.fullTableName(catalogName, baseTableIdentifier);
        String metadataTableName = BaseMetastoreCatalog.fullTableName(catalogName, metadataTableIdentifier);
        return MetadataTableUtils.createMetadataTableInstance(ops, baseTableName, metadataTableName, type);
    }

    private static String metadataTableName(String tableName, MetadataTableType type) {
        return tableName + (tableName.contains("/") ? "#" : ".") + type.name().toLowerCase(Locale.ROOT);
    }
}

