/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.transforms.PartitionSpecVisitor;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Partitioning {
    private Partitioning() {
    }

    public static boolean hasBucketField(PartitionSpec spec) {
        List<Boolean> bucketList = PartitionSpecVisitor.visit(spec, new PartitionSpecVisitor<Boolean>(){

            @Override
            public Boolean identity(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean bucket(int fieldId, String sourceName, int sourceId, int width) {
                return true;
            }

            @Override
            public Boolean truncate(int fieldId, String sourceName, int sourceId, int width) {
                return false;
            }

            @Override
            public Boolean year(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean month(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean day(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean hour(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean alwaysNull(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean unknown(int fieldId, String sourceName, int sourceId, String transform) {
                return false;
            }
        });
        return bucketList.stream().anyMatch(Boolean::booleanValue);
    }

    public static SortOrder sortOrderFor(PartitionSpec spec) {
        if (spec.isUnpartitioned()) {
            return SortOrder.unsorted();
        }
        SortOrder.Builder builder = SortOrder.builderFor(spec.schema());
        SpecToOrderVisitor converter = new SpecToOrderVisitor(builder);
        PartitionSpecVisitor.visit(spec, converter);
        String bucketColumn = converter.bucketColumn();
        if (bucketColumn != null) {
            builder.asc(bucketColumn);
        }
        return builder.build();
    }

    public static Types.StructType partitionType(Table table) {
        List<Transform<?, ?>> unknownTransforms = Partitioning.collectUnknownTransforms(table);
        ValidationException.check(unknownTransforms.isEmpty(), "Cannot build table partition type, unknown transforms: %s", unknownTransforms);
        if (table.specs().size() == 1) {
            return table.spec().partitionType();
        }
        HashMap<Integer, PartitionField> fieldMap = Maps.newHashMap();
        HashMap<Integer, Type> typeMap = Maps.newHashMap();
        HashMap<Integer, String> nameMap = Maps.newHashMap();
        List specIds = table.specs().keySet().stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
        for (Integer specId : specIds) {
            PartitionSpec spec = table.specs().get(specId);
            for (PartitionField field : spec.fields()) {
                int fieldId2 = field.fieldId();
                Types.NestedField structField = spec.partitionType().field(fieldId2);
                PartitionField existingField = (PartitionField)fieldMap.get(fieldId2);
                if (existingField == null) {
                    fieldMap.put(fieldId2, field);
                    typeMap.put(fieldId2, structField.type());
                    nameMap.put(fieldId2, structField.name());
                    continue;
                }
                ValidationException.check(Partitioning.equivalentIgnoringNames(field, existingField), "Conflicting partition fields: ['%s', '%s']", field, existingField);
                if (!Partitioning.isVoidTransform(existingField) || Partitioning.isVoidTransform(field)) continue;
                fieldMap.put(fieldId2, field);
                typeMap.put(fieldId2, structField.type());
            }
        }
        List<Types.NestedField> sortedStructFields = fieldMap.keySet().stream().sorted(Comparator.naturalOrder()).map(fieldId -> Types.NestedField.optional(fieldId, (String)nameMap.get(fieldId), (Type)typeMap.get(fieldId))).collect(Collectors.toList());
        return Types.StructType.of(sortedStructFields);
    }

    private static boolean isVoidTransform(PartitionField field) {
        return field.transform().equals(Transforms.alwaysNull());
    }

    private static List<Transform<?, ?>> collectUnknownTransforms(Table table) {
        ArrayList<Transform<?, ?>> unknownTransforms = Lists.newArrayList();
        table.specs().values().forEach(spec -> spec.fields().stream().map(PartitionField::transform).filter(transform -> transform instanceof UnknownTransform).forEach(unknownTransforms::add));
        return unknownTransforms;
    }

    private static boolean equivalentIgnoringNames(PartitionField field, PartitionField anotherField) {
        return field.fieldId() == anotherField.fieldId() && field.sourceId() == anotherField.sourceId() && Partitioning.compatibleTransforms(field.transform(), anotherField.transform());
    }

    private static boolean compatibleTransforms(Transform<?, ?> t1, Transform<?, ?> t2) {
        return t1.equals(t2) || t1.equals(Transforms.alwaysNull()) || t2.equals(Transforms.alwaysNull());
    }

    private static class SpecToOrderVisitor
    implements PartitionSpecVisitor<Void> {
        private final SortOrder.Builder builder;
        private String bucketColumn = null;
        private int highestNumBuckets = 0;

        private SpecToOrderVisitor(SortOrder.Builder builder) {
            this.builder = builder;
        }

        String bucketColumn() {
            return this.bucketColumn;
        }

        @Override
        public Void identity(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(sourceName);
            return null;
        }

        @Override
        public Void bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            if (numBuckets > this.highestNumBuckets) {
                this.highestNumBuckets = numBuckets;
                this.bucketColumn = sourceName;
            }
            this.builder.asc(Expressions.bucket(sourceName, numBuckets));
            return null;
        }

        @Override
        public Void truncate(int fieldId, String sourceName, int sourceId, int width) {
            this.builder.asc(Expressions.truncate(sourceName, width));
            return null;
        }

        @Override
        public Void year(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.year(sourceName));
            return null;
        }

        @Override
        public Void month(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.month(sourceName));
            return null;
        }

        @Override
        public Void day(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.day(sourceName));
            return null;
        }

        @Override
        public Void hour(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.hour(sourceName));
            return null;
        }

        @Override
        public Void alwaysNull(int fieldId, String sourceName, int sourceId) {
            return null;
        }
    }
}

