/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.FlinkWriteConf;
import org.apache.iceberg.flink.FlinkWriteOptions;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.sink.EqualityFieldKeySelector;
import org.apache.iceberg.flink.sink.IcebergFilesCommitter;
import org.apache.iceberg.flink.sink.IcebergStreamWriter;
import org.apache.iceberg.flink.sink.PartitionKeySelector;
import org.apache.iceberg.flink.sink.RowDataTaskWriterFactory;
import org.apache.iceberg.flink.util.FlinkCompatibilityUtil;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkSink {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkSink.class);
    private static final String ICEBERG_STREAM_WRITER_NAME = IcebergStreamWriter.class.getSimpleName();
    private static final String ICEBERG_FILES_COMMITTER_NAME = IcebergFilesCommitter.class.getSimpleName();

    private FlinkSink() {
    }

    public static <T> Builder builderFor(DataStream<T> input, MapFunction<T, RowData> mapper, TypeInformation<RowData> outputType) {
        return new Builder().forMapperOutputType(input, mapper, (TypeInformation<RowData>)outputType);
    }

    public static Builder forRow(DataStream<Row> input, TableSchema tableSchema) {
        RowType rowType = (RowType)tableSchema.toRowDataType().getLogicalType();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        DataFormatConverters.RowConverter rowConverter = new DataFormatConverters.RowConverter(fieldDataTypes);
        return FlinkSink.builderFor(input, arg_0 -> ((DataFormatConverters.RowConverter)rowConverter).toInternal(arg_0), FlinkCompatibilityUtil.toTypeInfo(rowType)).tableSchema(tableSchema);
    }

    public static Builder forRowData(DataStream<RowData> input) {
        return new Builder().forRowData((DataStream<RowData>)input);
    }

    static RowType toFlinkRowType(Schema schema, TableSchema requestedSchema) {
        if (requestedSchema != null) {
            Schema writeSchema = TypeUtil.reassignIds(FlinkSchemaUtil.convert(requestedSchema), schema);
            TypeUtil.validateWriteSchema(schema, writeSchema, true, true);
            return (RowType)requestedSchema.toRowDataType().getLogicalType();
        }
        return FlinkSchemaUtil.convert(schema);
    }

    static IcebergStreamWriter<RowData> createStreamWriter(Table table, FlinkWriteConf flinkWriteConf, RowType flinkRowType, List<Integer> equalityFieldIds) {
        Preconditions.checkArgument(table != null, "Iceberg table shouldn't be null");
        Table serializableTable = SerializableTable.copyOf(table);
        RowDataTaskWriterFactory taskWriterFactory = new RowDataTaskWriterFactory(serializableTable, flinkRowType, flinkWriteConf.targetDataFileSize(), flinkWriteConf.dataFileFormat(), equalityFieldIds, flinkWriteConf.upsertMode());
        return new IcebergStreamWriter<RowData>(table.name(), taskWriterFactory);
    }

    public static class Builder {
        private Function<String, DataStream<RowData>> inputCreator = null;
        private TableLoader tableLoader;
        private Table table;
        private TableSchema tableSchema;
        private Integer writeParallelism = null;
        private List<String> equalityFieldColumns = null;
        private String uidPrefix = null;
        private ReadableConfig readableConfig = new Configuration();
        private final Map<String, String> writeOptions = Maps.newHashMap();
        private FlinkWriteConf flinkWriteConf = null;

        private Builder() {
        }

        private Builder forRowData(DataStream<RowData> newRowDataInput) {
            this.inputCreator = ignored -> newRowDataInput;
            return this;
        }

        private <T> Builder forMapperOutputType(DataStream<T> input, MapFunction<T, RowData> mapper, TypeInformation<RowData> outputType) {
            this.inputCreator = newUidPrefix -> {
                SingleOutputStreamOperator inputStream = input.map(mapper, outputType).setParallelism(input.getParallelism());
                if (newUidPrefix != null) {
                    inputStream.name(this.operatorName((String)newUidPrefix)).uid(newUidPrefix + "-mapper");
                }
                return inputStream;
            };
            return this;
        }

        public Builder table(Table newTable) {
            this.table = newTable;
            return this;
        }

        public Builder tableLoader(TableLoader newTableLoader) {
            this.tableLoader = newTableLoader;
            return this;
        }

        public Builder set(String property, String value) {
            this.writeOptions.put(property, value);
            return this;
        }

        public Builder setAll(Map<String, String> properties) {
            this.writeOptions.putAll(properties);
            return this;
        }

        public Builder tableSchema(TableSchema newTableSchema) {
            this.tableSchema = newTableSchema;
            return this;
        }

        public Builder overwrite(boolean newOverwrite) {
            this.writeOptions.put(FlinkWriteOptions.OVERWRITE_MODE.key(), Boolean.toString(newOverwrite));
            return this;
        }

        public Builder flinkConf(ReadableConfig config) {
            this.readableConfig = config;
            return this;
        }

        public Builder distributionMode(DistributionMode mode) {
            Preconditions.checkArgument(!DistributionMode.RANGE.equals((Object)mode), "Flink does not support 'range' write distribution mode now.");
            if (mode != null) {
                this.writeOptions.put(FlinkWriteOptions.DISTRIBUTION_MODE.key(), mode.modeName());
            }
            return this;
        }

        public Builder writeParallelism(int newWriteParallelism) {
            this.writeParallelism = newWriteParallelism;
            return this;
        }

        public Builder upsert(boolean enabled) {
            this.writeOptions.put(FlinkWriteOptions.WRITE_UPSERT_ENABLED.key(), Boolean.toString(enabled));
            return this;
        }

        public Builder equalityFieldColumns(List<String> columns) {
            this.equalityFieldColumns = columns;
            return this;
        }

        public Builder uidPrefix(String newPrefix) {
            this.uidPrefix = newPrefix;
            return this;
        }

        private <T> DataStreamSink<T> chainIcebergOperators() {
            Preconditions.checkArgument(this.inputCreator != null, "Please use forRowData() or forMapperOutputType() to initialize the input DataStream.");
            Preconditions.checkNotNull(this.tableLoader, "Table loader shouldn't be null");
            DataStream<RowData> rowDataInput = this.inputCreator.apply(this.uidPrefix);
            if (this.table == null) {
                this.tableLoader.open();
                try (TableLoader loader = this.tableLoader;){
                    this.table = loader.loadTable();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to load iceberg table from table loader: " + this.tableLoader, e);
                }
            }
            this.flinkWriteConf = new FlinkWriteConf(this.table, this.writeOptions, this.readableConfig);
            List<Integer> equalityFieldIds = this.checkAndGetEqualityFieldIds();
            RowType flinkRowType = FlinkSink.toFlinkRowType(this.table.schema(), this.tableSchema);
            DataStream<RowData> distributeStream = this.distributeDataStream(rowDataInput, equalityFieldIds, this.table.spec(), this.table.schema(), flinkRowType);
            SingleOutputStreamOperator<WriteResult> writerStream = this.appendWriter(distributeStream, flinkRowType, equalityFieldIds);
            SingleOutputStreamOperator<Void> committerStream = this.appendCommitter(writerStream);
            return this.appendDummySink(committerStream);
        }

        public DataStreamSink<Void> append() {
            return this.chainIcebergOperators();
        }

        private String operatorName(String suffix) {
            return this.uidPrefix != null ? this.uidPrefix + "-" + suffix : suffix;
        }

        @VisibleForTesting
        List<Integer> checkAndGetEqualityFieldIds() {
            ArrayList<Integer> equalityFieldIds = Lists.newArrayList(this.table.schema().identifierFieldIds());
            if (this.equalityFieldColumns != null && this.equalityFieldColumns.size() > 0) {
                HashSet<Integer> equalityFieldSet = Sets.newHashSetWithExpectedSize(this.equalityFieldColumns.size());
                for (String column : this.equalityFieldColumns) {
                    Types.NestedField field = this.table.schema().findField(column);
                    Preconditions.checkNotNull(field, "Missing required equality field column '%s' in table schema %s", (Object)column, (Object)this.table.schema());
                    equalityFieldSet.add(field.fieldId());
                }
                if (!equalityFieldSet.equals(this.table.schema().identifierFieldIds())) {
                    LOG.warn("The configured equality field column IDs {} are not matched with the schema identifier field IDs {}, use job specified equality field columns as the equality fields by default.", equalityFieldSet, this.table.schema().identifierFieldIds());
                }
                equalityFieldIds = Lists.newArrayList(equalityFieldSet);
            }
            return equalityFieldIds;
        }

        private <T> DataStreamSink<T> appendDummySink(SingleOutputStreamOperator<Void> committerStream) {
            DataStreamSink resultStream = committerStream.addSink((SinkFunction)new DiscardingSink()).name(this.operatorName(String.format("IcebergSink %s", this.table.name()))).setParallelism(1);
            if (this.uidPrefix != null) {
                resultStream = resultStream.uid(this.uidPrefix + "-dummysink");
            }
            return resultStream;
        }

        private SingleOutputStreamOperator<Void> appendCommitter(SingleOutputStreamOperator<WriteResult> writerStream) {
            IcebergFilesCommitter filesCommitter = new IcebergFilesCommitter(this.tableLoader, this.flinkWriteConf.overwriteMode());
            SingleOutputStreamOperator committerStream = writerStream.transform(this.operatorName(ICEBERG_FILES_COMMITTER_NAME), Types.VOID, (OneInputStreamOperator)filesCommitter).setParallelism(1).setMaxParallelism(1);
            if (this.uidPrefix != null) {
                committerStream = committerStream.uid(this.uidPrefix + "-committer");
            }
            return committerStream;
        }

        private SingleOutputStreamOperator<WriteResult> appendWriter(DataStream<RowData> input, RowType flinkRowType, List<Integer> equalityFieldIds) {
            if (this.flinkWriteConf.upsertMode()) {
                Preconditions.checkState(!this.flinkWriteConf.overwriteMode(), "OVERWRITE mode shouldn't be enable when configuring to use UPSERT data stream.");
                Preconditions.checkState(!equalityFieldIds.isEmpty(), "Equality field columns shouldn't be empty when configuring to use UPSERT data stream.");
                if (!this.table.spec().isUnpartitioned()) {
                    for (PartitionField partitionField : this.table.spec().fields()) {
                        Preconditions.checkState(equalityFieldIds.contains(partitionField.sourceId()), "In UPSERT mode, partition field '%s' should be included in equality fields: '%s'", (Object)partitionField, this.equalityFieldColumns);
                    }
                }
            }
            IcebergStreamWriter<RowData> streamWriter = FlinkSink.createStreamWriter(this.table, this.flinkWriteConf, flinkRowType, equalityFieldIds);
            int parallelism = this.writeParallelism == null ? input.getParallelism() : this.writeParallelism.intValue();
            SingleOutputStreamOperator writerStream = input.transform(this.operatorName(ICEBERG_STREAM_WRITER_NAME), TypeInformation.of(WriteResult.class), streamWriter).setParallelism(parallelism);
            if (this.uidPrefix != null) {
                writerStream = writerStream.uid(this.uidPrefix + "-writer");
            }
            return writerStream;
        }

        private DataStream<RowData> distributeDataStream(DataStream<RowData> input, List<Integer> equalityFieldIds, PartitionSpec partitionSpec, Schema iSchema, RowType flinkRowType) {
            DistributionMode writeMode = this.flinkWriteConf.distributionMode();
            LOG.info("Write distribution mode is '{}'", (Object)writeMode.modeName());
            switch (writeMode) {
                case NONE: {
                    if (equalityFieldIds.isEmpty()) {
                        return input;
                    }
                    LOG.info("Distribute rows by equality fields, because there are equality fields set");
                    return input.keyBy((KeySelector)new EqualityFieldKeySelector(iSchema, flinkRowType, equalityFieldIds));
                }
                case HASH: {
                    if (equalityFieldIds.isEmpty()) {
                        if (partitionSpec.isUnpartitioned()) {
                            LOG.warn("Fallback to use 'none' distribution mode, because there are no equality fields set and table is unpartitioned");
                            return input;
                        }
                        return input.keyBy((KeySelector)new PartitionKeySelector(partitionSpec, iSchema, flinkRowType));
                    }
                    if (partitionSpec.isUnpartitioned()) {
                        LOG.info("Distribute rows by equality fields, because there are equality fields set and table is unpartitioned");
                        return input.keyBy((KeySelector)new EqualityFieldKeySelector(iSchema, flinkRowType, equalityFieldIds));
                    }
                    for (PartitionField partitionField : partitionSpec.fields()) {
                        Preconditions.checkState(equalityFieldIds.contains(partitionField.sourceId()), "In 'hash' distribution mode with equality fields set, partition field '%s' should be included in equality fields: '%s'", (Object)partitionField, this.equalityFieldColumns);
                    }
                    return input.keyBy((KeySelector)new PartitionKeySelector(partitionSpec, iSchema, flinkRowType));
                }
                case RANGE: {
                    if (equalityFieldIds.isEmpty()) {
                        LOG.warn("Fallback to use 'none' distribution mode, because there are no equality fields set and {}=range is not supported yet in flink", (Object)"write.distribution-mode");
                        return input;
                    }
                    LOG.info("Distribute rows by equality fields, because there are equality fields set and{}=range is not supported yet in flink", (Object)"write.distribution-mode");
                    return input.keyBy((KeySelector)new EqualityFieldKeySelector(iSchema, flinkRowType, equalityFieldIds));
                }
            }
            throw new RuntimeException("Unrecognized write.distribution-mode: " + (Object)((Object)writeMode));
        }
    }
}

