/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.source.FlinkInputSplit;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;

class FlinkSplitGenerator {
    private FlinkSplitGenerator() {
    }

    static FlinkInputSplit[] createInputSplits(Table table, ScanContext context) {
        List<CombinedScanTask> tasks = FlinkSplitGenerator.tasks(table, context);
        FlinkInputSplit[] splits = new FlinkInputSplit[tasks.size()];
        boolean exposeLocality = context.exposeLocality();
        Tasks.range(tasks.size()).stopOnFailure().executeWith(exposeLocality ? ThreadPools.getWorkerPool() : null).run(index -> {
            CombinedScanTask task = (CombinedScanTask)tasks.get((int)index);
            String[] hostnames = null;
            if (exposeLocality) {
                hostnames = Util.blockLocations(table.io(), task);
            }
            splits[index.intValue()] = new FlinkInputSplit((int)index, task, hostnames);
        });
        return splits;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<CombinedScanTask> tasks(Table table, ScanContext context) {
        TableScan scan = (TableScan)((TableScan)table.newScan().caseSensitive(context.caseSensitive())).project(context.project());
        if (context.snapshotId() != null) {
            scan = scan.useSnapshot(context.snapshotId());
        }
        if (context.asOfTimestamp() != null) {
            scan = scan.asOfTime(context.asOfTimestamp());
        }
        if (context.startSnapshotId() != null) {
            scan = context.endSnapshotId() != null ? scan.appendsBetween(context.startSnapshotId(), context.endSnapshotId()) : scan.appendsAfter(context.startSnapshotId());
        }
        if (context.splitSize() != null) {
            scan = (TableScan)scan.option("read.split.target-size", context.splitSize().toString());
        }
        if (context.splitLookback() != null) {
            scan = (TableScan)scan.option("read.split.planning-lookback", context.splitLookback().toString());
        }
        if (context.splitOpenFileCost() != null) {
            scan = (TableScan)scan.option("read.split.open-file-cost", context.splitOpenFileCost().toString());
        }
        if (context.filters() != null) {
            for (Expression filter : context.filters()) {
                scan = (TableScan)scan.filter(filter);
            }
        }
        try (CloseableIterable tasksIterable = scan.planTasks();){
            ArrayList<CombinedScanTask> arrayList = Lists.newArrayList(tasksIterable);
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close table scan: " + scan, e);
        }
    }
}

