/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;

class ScanContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ConfigOption<Long> SNAPSHOT_ID = ConfigOptions.key((String)"snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Boolean> CASE_SENSITIVE = ConfigOptions.key((String)"case-sensitive").booleanType().defaultValue((Object)false);
    private static final ConfigOption<Long> AS_OF_TIMESTAMP = ConfigOptions.key((String)"as-of-timestamp").longType().defaultValue(null);
    private static final ConfigOption<Long> START_SNAPSHOT_ID = ConfigOptions.key((String)"start-snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Long> END_SNAPSHOT_ID = ConfigOptions.key((String)"end-snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Long> SPLIT_SIZE = ConfigOptions.key((String)"split-size").longType().defaultValue(null);
    private static final ConfigOption<Integer> SPLIT_LOOKBACK = ConfigOptions.key((String)"split-lookback").intType().defaultValue(null);
    private static final ConfigOption<Long> SPLIT_FILE_OPEN_COST = ConfigOptions.key((String)"split-file-open-cost").longType().defaultValue(null);
    private static final ConfigOption<Boolean> STREAMING = ConfigOptions.key((String)"streaming").booleanType().defaultValue((Object)false);
    private static final ConfigOption<Duration> MONITOR_INTERVAL = ConfigOptions.key((String)"monitor-interval").durationType().defaultValue((Object)Duration.ofSeconds(10L));
    private final boolean caseSensitive;
    private final boolean exposeLocality;
    private final Long snapshotId;
    private final Long startSnapshotId;
    private final Long endSnapshotId;
    private final Long asOfTimestamp;
    private final Long splitSize;
    private final Integer splitLookback;
    private final Long splitOpenFileCost;
    private final boolean isStreaming;
    private final Duration monitorInterval;
    private final String nameMapping;
    private final Schema schema;
    private final List<Expression> filters;
    private final long limit;

    private ScanContext(boolean caseSensitive, Long snapshotId, Long startSnapshotId, Long endSnapshotId, Long asOfTimestamp, Long splitSize, Integer splitLookback, Long splitOpenFileCost, boolean isStreaming, Duration monitorInterval, String nameMapping, Schema schema, List<Expression> filters, long limit, boolean exposeLocality) {
        this.caseSensitive = caseSensitive;
        this.snapshotId = snapshotId;
        this.startSnapshotId = startSnapshotId;
        this.endSnapshotId = endSnapshotId;
        this.asOfTimestamp = asOfTimestamp;
        this.splitSize = splitSize;
        this.splitLookback = splitLookback;
        this.splitOpenFileCost = splitOpenFileCost;
        this.isStreaming = isStreaming;
        this.monitorInterval = monitorInterval;
        this.nameMapping = nameMapping;
        this.schema = schema;
        this.filters = filters;
        this.limit = limit;
        this.exposeLocality = exposeLocality;
    }

    boolean caseSensitive() {
        return this.caseSensitive;
    }

    Long snapshotId() {
        return this.snapshotId;
    }

    Long startSnapshotId() {
        return this.startSnapshotId;
    }

    Long endSnapshotId() {
        return this.endSnapshotId;
    }

    Long asOfTimestamp() {
        return this.asOfTimestamp;
    }

    Long splitSize() {
        return this.splitSize;
    }

    Integer splitLookback() {
        return this.splitLookback;
    }

    Long splitOpenFileCost() {
        return this.splitOpenFileCost;
    }

    boolean isStreaming() {
        return this.isStreaming;
    }

    Duration monitorInterval() {
        return this.monitorInterval;
    }

    String nameMapping() {
        return this.nameMapping;
    }

    Schema project() {
        return this.schema;
    }

    List<Expression> filters() {
        return this.filters;
    }

    long limit() {
        return this.limit;
    }

    boolean exposeLocality() {
        return this.exposeLocality;
    }

    ScanContext copyWithAppendsBetween(long newStartSnapshotId, long newEndSnapshotId) {
        return ScanContext.builder().caseSensitive(this.caseSensitive).useSnapshotId(null).startSnapshotId(newStartSnapshotId).endSnapshotId(newEndSnapshotId).asOfTimestamp(null).splitSize(this.splitSize).splitLookback(this.splitLookback).splitOpenFileCost(this.splitOpenFileCost).streaming(this.isStreaming).monitorInterval(this.monitorInterval).nameMapping(this.nameMapping).project(this.schema).filters(this.filters).limit(this.limit).exposeLocality(this.exposeLocality).build();
    }

    ScanContext copyWithSnapshotId(long newSnapshotId) {
        return ScanContext.builder().caseSensitive(this.caseSensitive).useSnapshotId(newSnapshotId).startSnapshotId(null).endSnapshotId(null).asOfTimestamp(null).splitSize(this.splitSize).splitLookback(this.splitLookback).splitOpenFileCost(this.splitOpenFileCost).streaming(this.isStreaming).monitorInterval(this.monitorInterval).nameMapping(this.nameMapping).project(this.schema).filters(this.filters).limit(this.limit).exposeLocality(this.exposeLocality).build();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private boolean caseSensitive = (Boolean)ScanContext.access$100().defaultValue();
        private Long snapshotId = (Long)ScanContext.access$200().defaultValue();
        private Long startSnapshotId = (Long)ScanContext.access$300().defaultValue();
        private Long endSnapshotId = (Long)ScanContext.access$400().defaultValue();
        private Long asOfTimestamp = (Long)ScanContext.access$500().defaultValue();
        private Long splitSize = (Long)ScanContext.access$600().defaultValue();
        private Integer splitLookback = (Integer)ScanContext.access$700().defaultValue();
        private Long splitOpenFileCost = (Long)ScanContext.access$800().defaultValue();
        private boolean isStreaming = (Boolean)ScanContext.access$900().defaultValue();
        private Duration monitorInterval = (Duration)ScanContext.access$1000().defaultValue();
        private String nameMapping;
        private Schema projectedSchema;
        private List<Expression> filters;
        private long limit = -1L;
        private boolean exposeLocality;

        private Builder() {
        }

        Builder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        Builder useSnapshotId(Long newSnapshotId) {
            this.snapshotId = newSnapshotId;
            return this;
        }

        Builder startSnapshotId(Long newStartSnapshotId) {
            this.startSnapshotId = newStartSnapshotId;
            return this;
        }

        Builder endSnapshotId(Long newEndSnapshotId) {
            this.endSnapshotId = newEndSnapshotId;
            return this;
        }

        Builder asOfTimestamp(Long newAsOfTimestamp) {
            this.asOfTimestamp = newAsOfTimestamp;
            return this;
        }

        Builder splitSize(Long newSplitSize) {
            this.splitSize = newSplitSize;
            return this;
        }

        Builder splitLookback(Integer newSplitLookback) {
            this.splitLookback = newSplitLookback;
            return this;
        }

        Builder splitOpenFileCost(Long newSplitOpenFileCost) {
            this.splitOpenFileCost = newSplitOpenFileCost;
            return this;
        }

        Builder streaming(boolean streaming) {
            this.isStreaming = streaming;
            return this;
        }

        Builder monitorInterval(Duration newMonitorInterval) {
            this.monitorInterval = newMonitorInterval;
            return this;
        }

        Builder nameMapping(String newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        Builder project(Schema newProjectedSchema) {
            this.projectedSchema = newProjectedSchema;
            return this;
        }

        Builder filters(List<Expression> newFilters) {
            this.filters = newFilters;
            return this;
        }

        Builder limit(long newLimit) {
            this.limit = newLimit;
            return this;
        }

        Builder exposeLocality(boolean newExposeLocality) {
            this.exposeLocality = newExposeLocality;
            return this;
        }

        Builder fromProperties(Map<String, String> properties) {
            Configuration config = new Configuration();
            properties.forEach((arg_0, arg_1) -> ((Configuration)config).setString(arg_0, arg_1));
            return this.useSnapshotId((Long)config.get(SNAPSHOT_ID)).caseSensitive((Boolean)config.get(CASE_SENSITIVE)).asOfTimestamp((Long)config.get(AS_OF_TIMESTAMP)).startSnapshotId((Long)config.get(START_SNAPSHOT_ID)).endSnapshotId((Long)config.get(END_SNAPSHOT_ID)).splitSize((Long)config.get(SPLIT_SIZE)).splitLookback((Integer)config.get(SPLIT_LOOKBACK)).splitOpenFileCost((Long)config.get(SPLIT_FILE_OPEN_COST)).streaming((Boolean)config.get(STREAMING)).monitorInterval((Duration)config.get(MONITOR_INTERVAL)).nameMapping(properties.get("schema.name-mapping.default"));
        }

        public ScanContext build() {
            return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.isStreaming, this.monitorInterval, this.nameMapping, this.projectedSchema, this.filters, this.limit, this.exposeLocality);
        }
    }
}

