/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class ReassignIds
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final Schema sourceSchema;
    private final TypeUtil.NextID assignId;
    private Type sourceType;

    ReassignIds(Schema sourceSchema, TypeUtil.NextID nextID) {
        this.sourceSchema = sourceSchema;
        this.assignId = nextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type schema(Schema schema, Supplier<Type> future) {
        this.sourceType = this.sourceSchema.asStruct();
        try {
            Type type = future.get();
            return type;
        }
        finally {
            this.sourceType = null;
        }
    }

    private int id(Types.StructType sourceStruct, String name) {
        Types.NestedField sourceField = sourceStruct.field(name);
        if (sourceField != null) {
            return sourceField.fieldId();
        }
        if (this.assignId != null) {
            return this.assignId.get();
        }
        throw new IllegalArgumentException("Field " + name + " not found in source schema");
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> fieldTypes) {
        Preconditions.checkNotNull(this.sourceType, "Evaluation must start with a schema.");
        Preconditions.checkArgument(this.sourceType.isStructType(), "Not a struct: %s", (Object)this.sourceType);
        Types.StructType sourceStruct = this.sourceType.asStructType();
        List<Types.NestedField> fields = struct.fields();
        int length = fields.size();
        ArrayList<Type> types = Lists.newArrayList(fieldTypes);
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(length);
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            int fieldId = this.id(sourceStruct, field.name());
            if (field.isRequired()) {
                newFields.add(Types.NestedField.required(fieldId, field.name(), (Type)types.get(i), field.doc()));
                continue;
            }
            newFields.add(Types.NestedField.optional(fieldId, field.name(), (Type)types.get(i), field.doc()));
        }
        return Types.StructType.of(newFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type field(Types.NestedField field, Supplier<Type> future) {
        Preconditions.checkArgument(this.sourceType.isStructType(), "Not a struct: %s", (Object)this.sourceType);
        Types.StructType sourceStruct = this.sourceType.asStructType();
        Types.NestedField sourceField = sourceStruct.field(field.name());
        if (sourceField != null) {
            this.sourceType = sourceField.type();
            try {
                Type type = future.get();
                return type;
            }
            finally {
                this.sourceType = sourceStruct;
            }
        }
        if (this.assignId != null) {
            return TypeUtil.assignFreshIds(field.type(), this.assignId);
        }
        throw new IllegalArgumentException("Field " + field.name() + " not found in source schema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type list(Types.ListType list, Supplier<Type> elementTypeFuture) {
        Preconditions.checkArgument(this.sourceType.isListType(), "Not a list: %s", (Object)this.sourceType);
        Types.ListType sourceList = this.sourceType.asListType();
        int sourceElementId = sourceList.elementId();
        this.sourceType = sourceList.elementType();
        try {
            if (list.isElementOptional()) {
                Types.ListType listType = Types.ListType.ofOptional(sourceElementId, elementTypeFuture.get());
                return listType;
            }
            Types.ListType listType = Types.ListType.ofRequired(sourceElementId, elementTypeFuture.get());
            return listType;
        }
        finally {
            this.sourceType = sourceList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type map(Types.MapType map, Supplier<Type> keyTypeFuture, Supplier<Type> valueTypeFuture) {
        Preconditions.checkArgument(this.sourceType.isMapType(), "Not a map: %s", (Object)this.sourceType);
        Types.MapType sourceMap = this.sourceType.asMapType();
        int sourceKeyId = sourceMap.keyId();
        int sourceValueId = sourceMap.valueId();
        try {
            this.sourceType = sourceMap.keyType();
            Type keyType = keyTypeFuture.get();
            this.sourceType = sourceMap.valueType();
            Type valueType = valueTypeFuture.get();
            if (map.isValueOptional()) {
                Types.MapType mapType = Types.MapType.ofOptional(sourceKeyId, sourceValueId, keyType, valueType);
                return mapType;
            }
            Types.MapType mapType = Types.MapType.ofRequired(sourceKeyId, sourceValueId, keyType, valueType);
            return mapType;
        }
        finally {
            this.sourceType = sourceMap;
        }
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }
}

