/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;

final class HttpRuntimeConfig {
    private final URI baseUri;
    private final ObjectMapper mapper;
    private final int readTimeoutMillis;
    private final int connectionTimeoutMillis;
    private final boolean disableCompression;
    private final SSLContext sslContext;
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;

    HttpRuntimeConfig(URI baseUri, ObjectMapper mapper, int readTimeoutMillis, int connectionTimeoutMillis, boolean disableCompression, SSLContext sslContext, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters) {
        this.baseUri = Objects.requireNonNull(baseUri);
        if (!"http".equals(baseUri.getScheme()) && !"https".equals(baseUri.getScheme())) {
            throw new IllegalArgumentException(String.format("Cannot start http client. %s must be a valid http or https address", baseUri));
        }
        this.mapper = mapper;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.disableCompression = disableCompression;
        this.sslContext = sslContext;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    URI getBaseUri() {
        return this.baseUri;
    }

    ObjectMapper getMapper() {
        return this.mapper;
    }

    int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    boolean isDisableCompression() {
        return this.disableCompression;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    List<ResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }
}

