/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.GenericMetadata;
import org.projectnessie.model.ImmutableIcebergTable;

@Schema(type=SchemaType.OBJECT, title="Iceberg table state", description="Represents the state of an Iceberg table in Nessie. An Iceberg table is globally identified via its unique 'Content.id'.\n\nA Nessie commit-operation, performed via 'TreeApi.commitMultipleOperations',for Iceberg consists of a 'Operation.Put' with an 'IcebergTable' as in the 'content' field and the previous value of 'IcebergTable' in the 'expectedContent' field.")
@JsonSerialize(as=ImmutableIcebergTable.class)
@JsonDeserialize(as=ImmutableIcebergTable.class)
@JsonTypeName(value="ICEBERG_TABLE")
@Value.Immutable
public abstract class IcebergTable
extends Content {
    @NotNull
    @NotBlank
    public abstract String getMetadataLocation();

    public abstract long getSnapshotId();

    public abstract int getSchemaId();

    public abstract int getSpecId();

    public abstract int getSortOrderId();

    @Override
    public Content.Type getType() {
        return Content.Type.ICEBERG_TABLE;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public abstract GenericMetadata getMetadata();

    public static ImmutableIcebergTable.Builder builder() {
        return ImmutableIcebergTable.builder();
    }

    public static IcebergTable of(String metadataLocation, long snapshotId, int schemaId, int specId, int sortOrderId) {
        return IcebergTable.builder().metadataLocation(metadataLocation).snapshotId(snapshotId).schemaId(schemaId).specId(specId).sortOrderId(sortOrderId).build();
    }

    public static IcebergTable of(String metadataLocation, long snapshotId, int schemaId, int specId, int sortOrderId, String contentId) {
        return IcebergTable.builder().metadataLocation(metadataLocation).snapshotId(snapshotId).schemaId(schemaId).specId(specId).sortOrderId(sortOrderId).id(contentId).build();
    }
}

