/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.GenericMetadata;
import org.projectnessie.model.ImmutableIcebergView;

@JsonSerialize(as=ImmutableIcebergView.class)
@JsonDeserialize(as=ImmutableIcebergView.class)
@JsonTypeName(value="ICEBERG_VIEW")
@Value.Immutable
public abstract class IcebergView
extends Content {
    @NotNull
    @NotBlank
    public abstract String getMetadataLocation();

    public abstract int getVersionId();

    public abstract int getSchemaId();

    @NotBlank
    @NotNull
    public abstract String getSqlText();

    @Nullable
    public abstract String getDialect();

    @Override
    public Content.Type getType() {
        return Content.Type.ICEBERG_VIEW;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public abstract GenericMetadata getMetadata();

    public static ImmutableIcebergView.Builder builder() {
        return ImmutableIcebergView.builder();
    }

    public static IcebergView of(String metadataLocation, int versionId, int schemaId, String dialect, String sqlText) {
        return IcebergView.builder().metadataLocation(metadataLocation).versionId(versionId).schemaId(schemaId).dialect(dialect).sqlText(sqlText).build();
    }

    public static IcebergView of(String id, String metadataLocation, int versionId, int schemaId, String dialect, String sqlText) {
        return IcebergView.builder().id(id).metadataLocation(metadataLocation).versionId(versionId).schemaId(schemaId).dialect(dialect).sqlText(sqlText).build();
    }
}

