/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class BaseFileScanTask
implements FileScanTask {
    private final DataFile file;
    private final DeleteFile[] deletes;
    private final String schemaString;
    private final String specString;
    private final ResidualEvaluator residuals;
    private transient PartitionSpec spec = null;

    public BaseFileScanTask(DataFile file, DeleteFile[] deletes, String schemaString, String specString, ResidualEvaluator residuals) {
        this.file = file;
        this.deletes = deletes != null ? deletes : new DeleteFile[]{};
        this.schemaString = schemaString;
        this.specString = specString;
        this.residuals = residuals;
    }

    @Override
    public DataFile file() {
        return this.file;
    }

    @Override
    public List<DeleteFile> deletes() {
        return ImmutableList.copyOf(this.deletes);
    }

    @Override
    public PartitionSpec spec() {
        if (this.spec == null) {
            this.spec = PartitionSpecParser.fromJson(SchemaParser.fromJson(this.schemaString), this.specString);
        }
        return this.spec;
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    public long length() {
        return this.file.fileSizeInBytes();
    }

    @Override
    public Expression residual() {
        return this.residuals.residualFor(this.file.partition());
    }

    @Override
    public Iterable<FileScanTask> split(long targetSplitSize) {
        if (this.file.format().isSplittable()) {
            if (this.file.splitOffsets() != null) {
                return () -> new OffsetsAwareTargetSplitSizeScanTaskIterator(this.file.splitOffsets(), this);
            }
            return () -> new FixedSizeSplitScanTaskIterator(targetSplitSize, this);
        }
        return ImmutableList.of(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("file", this.file.path()).add("partition_data", this.file.partition()).add("residual", this.residual()).toString();
    }

    private static final class SplitScanTask
    implements FileScanTask,
    MergeableScanTask<SplitScanTask> {
        private final long len;
        private final long offset;
        private final FileScanTask fileScanTask;

        SplitScanTask(long offset, long len, FileScanTask fileScanTask) {
            this.offset = offset;
            this.len = len;
            this.fileScanTask = fileScanTask;
        }

        @Override
        public DataFile file() {
            return (DataFile)this.fileScanTask.file();
        }

        @Override
        public List<DeleteFile> deletes() {
            return this.fileScanTask.deletes();
        }

        @Override
        public PartitionSpec spec() {
            return this.fileScanTask.spec();
        }

        @Override
        public long start() {
            return this.offset;
        }

        @Override
        public long length() {
            return this.len;
        }

        @Override
        public Expression residual() {
            return this.fileScanTask.residual();
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            throw new UnsupportedOperationException("Cannot split a task which is already split");
        }

        @Override
        public boolean canMerge(ScanTask other) {
            if (other instanceof SplitScanTask) {
                SplitScanTask that = (SplitScanTask)other;
                return this.file().equals(that.file()) && this.offset + this.len == that.start();
            }
            return false;
        }

        @Override
        public SplitScanTask merge(ScanTask other) {
            SplitScanTask that = (SplitScanTask)other;
            return new SplitScanTask(this.offset, this.len + that.length(), this.fileScanTask);
        }
    }

    @VisibleForTesting
    static final class FixedSizeSplitScanTaskIterator
    implements Iterator<FileScanTask> {
        private long offset = 0L;
        private long remainingLen;
        private long splitSize;
        private final FileScanTask fileScanTask;

        FixedSizeSplitScanTaskIterator(long splitSize, FileScanTask fileScanTask) {
            this.remainingLen = fileScanTask.length();
            this.splitSize = splitSize;
            this.fileScanTask = fileScanTask;
        }

        @Override
        public boolean hasNext() {
            return this.remainingLen > 0L;
        }

        @Override
        public FileScanTask next() {
            long len = Math.min(this.splitSize, this.remainingLen);
            SplitScanTask splitTask = new SplitScanTask(this.offset, len, this.fileScanTask);
            this.offset += len;
            this.remainingLen -= len;
            return splitTask;
        }
    }

    @VisibleForTesting
    static final class OffsetsAwareTargetSplitSizeScanTaskIterator
    implements Iterator<FileScanTask> {
        private final List<Long> offsets;
        private final List<Long> splitSizes;
        private final FileScanTask parentScanTask;
        private int sizeIdx = 0;

        OffsetsAwareTargetSplitSizeScanTaskIterator(List<Long> offsetList, FileScanTask parentScanTask) {
            this.offsets = ImmutableList.copyOf(offsetList);
            this.parentScanTask = parentScanTask;
            this.splitSizes = Lists.newArrayListWithCapacity(this.offsets.size());
            if (this.offsets.size() > 0) {
                int lastIndex = this.offsets.size() - 1;
                for (int index = 0; index < lastIndex; ++index) {
                    this.splitSizes.add(this.offsets.get(index + 1) - this.offsets.get(index));
                }
                this.splitSizes.add(parentScanTask.length() - this.offsets.get(lastIndex));
            }
        }

        @Override
        public boolean hasNext() {
            return this.sizeIdx < this.splitSizes.size();
        }

        @Override
        public FileScanTask next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int offsetIdx = this.sizeIdx;
            long currentSize = this.splitSizes.get(this.sizeIdx);
            ++this.sizeIdx;
            return new SplitScanTask(this.offsets.get(offsetIdx), currentSize, this.parentScanTask);
        }
    }
}

