/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;

public class DataFilesTable
extends BaseFilesTable {
    DataFilesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".data_files");
    }

    DataFilesTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    @Override
    public TableScan newScan() {
        return new DataFilesTableScan(this.operations(), this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.DATA_FILES;
    }

    public static class DataFilesTableScan
    extends BaseFilesTable.BaseFilesTableScan {
        DataFilesTableScan(TableOperations ops, Table table, Schema schema) {
            super(ops, table, schema, MetadataTableType.DATA_FILES);
        }

        DataFilesTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, MetadataTableType.DATA_FILES, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new DataFilesTableScan(ops, table, schema, context);
        }

        @Override
        protected CloseableIterable<ManifestFile> manifests() {
            return CloseableIterable.withNoopClose(this.snapshot().dataManifests(this.tableOps().io()));
        }
    }
}

