/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFileIndex;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;

class ManifestGroup {
    private static final Types.StructType EMPTY_STRUCT = Types.StructType.of(new Types.NestedField[0]);
    private final FileIO io;
    private final Set<ManifestFile> dataManifests;
    private final DeleteFileIndex.Builder deleteIndexBuilder;
    private Predicate<ManifestFile> manifestPredicate;
    private Predicate<ManifestEntry<DataFile>> manifestEntryPredicate;
    private Map<Integer, PartitionSpec> specsById;
    private Expression dataFilter;
    private Expression fileFilter;
    private Expression partitionFilter;
    private boolean ignoreDeleted;
    private boolean ignoreExisting;
    private boolean ignoreResiduals;
    private List<String> columns;
    private boolean caseSensitive;
    private ExecutorService executorService;

    ManifestGroup(FileIO io, Iterable<ManifestFile> manifests) {
        this(io, Iterables.filter(manifests, manifest -> manifest.content() == ManifestContent.DATA), Iterables.filter(manifests, manifest -> manifest.content() == ManifestContent.DELETES));
    }

    ManifestGroup(FileIO io, Iterable<ManifestFile> dataManifests, Iterable<ManifestFile> deleteManifests) {
        this.io = io;
        this.dataManifests = Sets.newHashSet(dataManifests);
        this.deleteIndexBuilder = DeleteFileIndex.builderFor(io, deleteManifests);
        this.dataFilter = Expressions.alwaysTrue();
        this.fileFilter = Expressions.alwaysTrue();
        this.partitionFilter = Expressions.alwaysTrue();
        this.ignoreDeleted = false;
        this.ignoreExisting = false;
        this.ignoreResiduals = false;
        this.columns = ManifestReader.ALL_COLUMNS;
        this.caseSensitive = true;
        this.manifestPredicate = m4 -> true;
        this.manifestEntryPredicate = e -> true;
    }

    ManifestGroup specsById(Map<Integer, PartitionSpec> newSpecsById) {
        this.specsById = newSpecsById;
        this.deleteIndexBuilder.specsById(newSpecsById);
        return this;
    }

    ManifestGroup filterData(Expression newDataFilter) {
        this.dataFilter = Expressions.and(this.dataFilter, newDataFilter);
        this.deleteIndexBuilder.filterData(newDataFilter);
        return this;
    }

    ManifestGroup filterFiles(Expression newFileFilter) {
        this.fileFilter = Expressions.and(this.fileFilter, newFileFilter);
        return this;
    }

    ManifestGroup filterPartitions(Expression newPartitionFilter) {
        this.partitionFilter = Expressions.and(this.partitionFilter, newPartitionFilter);
        this.deleteIndexBuilder.filterPartitions(newPartitionFilter);
        return this;
    }

    ManifestGroup filterManifests(Predicate<ManifestFile> newManifestPredicate) {
        this.manifestPredicate = this.manifestPredicate.and(newManifestPredicate);
        return this;
    }

    ManifestGroup filterManifestEntries(Predicate<ManifestEntry<DataFile>> newManifestEntryPredicate) {
        this.manifestEntryPredicate = this.manifestEntryPredicate.and(newManifestEntryPredicate);
        return this;
    }

    ManifestGroup ignoreDeleted() {
        this.ignoreDeleted = true;
        return this;
    }

    ManifestGroup ignoreExisting() {
        this.ignoreExisting = true;
        return this;
    }

    ManifestGroup ignoreResiduals() {
        this.ignoreResiduals = true;
        return this;
    }

    ManifestGroup select(List<String> newColumns) {
        this.columns = Lists.newArrayList(newColumns);
        return this;
    }

    ManifestGroup caseSensitive(boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
        this.deleteIndexBuilder.caseSensitive(newCaseSensitive);
        return this;
    }

    ManifestGroup planWith(ExecutorService newExecutorService) {
        this.executorService = newExecutorService;
        this.deleteIndexBuilder.planWith(newExecutorService);
        return this;
    }

    public CloseableIterable<FileScanTask> planFiles() {
        LoadingCache<Integer, ResidualEvaluator> residualCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = this.specsById.get(specId);
            Expression filter = this.ignoreResiduals ? Expressions.alwaysTrue() : this.dataFilter;
            return ResidualEvaluator.of(spec, filter, this.caseSensitive);
        });
        DeleteFileIndex deleteFiles = this.deleteIndexBuilder.build();
        boolean dropStats = ManifestReader.dropStats(this.dataFilter, this.columns);
        if (!deleteFiles.isEmpty()) {
            this.select(ManifestReader.withStatsColumns(this.columns));
        }
        Iterable tasks = this.entries((manifest, entries) -> {
            int specId = manifest.partitionSpecId();
            PartitionSpec spec = this.specsById.get(specId);
            String schemaString = SchemaParser.toJson(spec.schema());
            String specString = PartitionSpecParser.toJson(spec);
            ResidualEvaluator residuals = (ResidualEvaluator)residualCache.get(specId);
            return CloseableIterable.transform(entries, e -> new BaseFileScanTask((DataFile)((DataFile)e.file()).copy(!dropStats), deleteFiles.forEntry((ManifestEntry<DataFile>)e), schemaString, specString, residuals));
        });
        if (this.executorService != null) {
            return new ParallelIterable<FileScanTask>(tasks, this.executorService);
        }
        return CloseableIterable.concat(tasks);
    }

    public CloseableIterable<ManifestEntry<DataFile>> entries() {
        return CloseableIterable.concat(this.entries((manifest, entries) -> entries));
    }

    private <T> Iterable<CloseableIterable<T>> entries(BiFunction<ManifestFile, CloseableIterable<ManifestEntry<DataFile>>, CloseableIterable<T>> entryFn) {
        Iterable<ManifestFile> matchingManifests;
        LoadingCache<Integer, ManifestEvaluator> evalCache = this.specsById == null ? null : Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = this.specsById.get(specId);
            return ManifestEvaluator.forPartitionFilter(Expressions.and(this.partitionFilter, Projections.inclusive(spec, this.caseSensitive).project(this.dataFilter)), spec, this.caseSensitive);
        });
        Evaluator evaluator = this.fileFilter != null && this.fileFilter != Expressions.alwaysTrue() ? new Evaluator(DataFile.getType(EMPTY_STRUCT), this.fileFilter, this.caseSensitive) : null;
        Iterable<ManifestFile> iterable = matchingManifests = evalCache == null ? this.dataManifests : Iterables.filter(this.dataManifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        if (this.ignoreDeleted) {
            matchingManifests = Iterables.filter(matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles());
        }
        if (this.ignoreExisting) {
            matchingManifests = Iterables.filter(matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasDeletedFiles());
        }
        matchingManifests = Iterables.filter(matchingManifests, this.manifestPredicate::test);
        return Iterables.transform(matchingManifests, manifest -> new CloseableIterable<T>((ManifestFile)manifest, evaluator, entryFn){
            private CloseableIterable iterable;
            final /* synthetic */ ManifestFile val$manifest;
            final /* synthetic */ Evaluator val$evaluator;
            final /* synthetic */ BiFunction val$entryFn;
            {
                this.val$manifest = manifestFile;
                this.val$evaluator = evaluator;
                this.val$entryFn = biFunction;
            }

            @Override
            public CloseableIterator<T> iterator() {
                ManifestReader<DataFile> reader = ManifestFiles.read(this.val$manifest, ManifestGroup.this.io, ManifestGroup.this.specsById).filterRows(ManifestGroup.this.dataFilter).filterPartitions(ManifestGroup.this.partitionFilter).caseSensitive(ManifestGroup.this.caseSensitive).select(ManifestGroup.this.columns);
                CloseableIterable<ManifestEntry<DataFile>> entries = reader.entries();
                if (ManifestGroup.this.ignoreDeleted) {
                    entries = reader.liveEntries();
                }
                if (ManifestGroup.this.ignoreExisting) {
                    entries = CloseableIterable.filter(entries, entry -> entry.status() != ManifestEntry.Status.EXISTING);
                }
                if (this.val$evaluator != null) {
                    entries = CloseableIterable.filter(entries, entry -> this.val$evaluator.eval((GenericDataFile)entry.file()));
                }
                entries = CloseableIterable.filter(entries, ManifestGroup.this.manifestEntryPredicate);
                this.iterable = (CloseableIterable)this.val$entryFn.apply(this.val$manifest, entries);
                return this.iterable.iterator();
            }

            @Override
            public void close() throws IOException {
                if (this.iterable != null) {
                    this.iterable.close();
                }
            }
        });
    }
}

