/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun.oss;

import com.aliyun.oss.OSS;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.aliyun.AliyunClientFactories;
import org.apache.iceberg.aliyun.AliyunClientFactory;
import org.apache.iceberg.aliyun.AliyunProperties;
import org.apache.iceberg.aliyun.oss.OSSInputFile;
import org.apache.iceberg.aliyun.oss.OSSOutputFile;
import org.apache.iceberg.aliyun.oss.OSSURI;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSFileIO
implements FileIO {
    private static final Logger LOG = LoggerFactory.getLogger(OSSFileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private SerializableSupplier<OSS> oss;
    private AliyunProperties aliyunProperties;
    private volatile transient OSS client;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);

    public OSSFileIO() {
    }

    public OSSFileIO(SerializableSupplier<OSS> oss) {
        this.oss = oss;
        this.aliyunProperties = new AliyunProperties();
    }

    @Override
    public InputFile newInputFile(String path) {
        return new OSSInputFile(this.client(), new OSSURI(path), this.aliyunProperties, this.metrics);
    }

    @Override
    public OutputFile newOutputFile(String path) {
        return new OSSOutputFile(this.client(), new OSSURI(path), this.aliyunProperties, this.metrics);
    }

    @Override
    public void deleteFile(String path) {
        OSSURI location = new OSSURI(path);
        this.client().deleteObject(location.bucket(), location.key());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSS client() {
        if (this.client == null) {
            OSSFileIO oSSFileIO = this;
            synchronized (oSSFileIO) {
                if (this.client == null) {
                    this.client = (OSS)this.oss.get();
                }
            }
        }
        return this.client;
    }

    @Override
    public void initialize(Map<String, String> properties) {
        AliyunClientFactory factory = AliyunClientFactories.from(properties);
        this.aliyunProperties = factory.aliyunProperties();
        this.oss = factory::newOSSClient;
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, String.class).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance("oss");
            context.initialize(properties);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL, (Object)e);
        }
    }

    @Override
    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true) && this.client != null) {
            this.client.shutdown();
        }
    }
}

