/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.List;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;

public class TableIdentifierParser {
    private static final String NAMESPACE = "namespace";
    private static final String NAME = "name";

    private TableIdentifierParser() {
    }

    public static String toJson(TableIdentifier identifier) {
        return TableIdentifierParser.toJson(identifier, false);
    }

    public static String toJson(TableIdentifier identifier, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator(writer);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            TableIdentifierParser.toJson(identifier, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to write json for: %s", identifier), e);
        }
    }

    public static void toJson(TableIdentifier identifier, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName(NAMESPACE);
        generator.writeArray(identifier.namespace().levels(), 0, identifier.namespace().length());
        generator.writeStringField(NAME, identifier.name());
        generator.writeEndObject();
    }

    public static TableIdentifier fromJson(String json) {
        Preconditions.checkArgument(json != null, "Cannot parse table identifier from invalid JSON: null");
        Preconditions.checkArgument(!json.isEmpty(), "Cannot parse table identifier from invalid JSON: ''");
        try {
            return TableIdentifierParser.fromJson(JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Cannot parse table identifier from invalid JSON: %s", json), e);
        }
    }

    public static TableIdentifier fromJson(JsonNode node) {
        Preconditions.checkArgument(node != null && !node.isNull() && node.isObject(), "Cannot parse missing or non-object table identifier: %s", (Object)node);
        List<String> levels = JsonUtil.getStringListOrNull(NAMESPACE, node);
        String tableName = JsonUtil.getString(NAME, node);
        Namespace namespace = levels == null ? Namespace.empty() : Namespace.of(levels.toArray(new String[0]));
        return TableIdentifier.of(namespace, tableName);
    }
}

