/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.Accessor;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Reference;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class BoundReference<T>
implements BoundTerm<T>,
Reference<T> {
    private final Types.NestedField field;
    private final Accessor<StructLike> accessor;

    BoundReference(Types.NestedField field, Accessor<StructLike> accessor) {
        this.field = field;
        this.accessor = accessor;
    }

    @Override
    public T eval(StructLike struct) {
        return (T)this.accessor.get(struct);
    }

    public Types.NestedField field() {
        return this.field;
    }

    @Override
    public BoundReference<T> ref() {
        return this;
    }

    @Override
    public Type type() {
        return this.field.type();
    }

    @Override
    public boolean isEquivalentTo(BoundTerm<?> other) {
        if (other instanceof BoundReference) {
            Types.NestedField otherField = ((BoundReference)other).field();
            return this.field.fieldId() == otherField.fieldId() && this.field.type().equals(otherField.type()) && this.field.isOptional() == otherField.isOptional();
        }
        return other.isEquivalentTo(this);
    }

    public int fieldId() {
        return this.field.fieldId();
    }

    public Accessor<StructLike> accessor() {
        return this.accessor;
    }

    public String toString() {
        return String.format("ref(id=%d, accessor-type=%s)", this.field.fieldId(), this.accessor.type());
    }
}

