/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;

public class FlinkParquetReaders {
    private FlinkParquetReaders() {
    }

    public static ParquetValueReader<RowData> buildReader(Schema expectedSchema, MessageType fileSchema) {
        return FlinkParquetReaders.buildReader(expectedSchema, fileSchema, ImmutableMap.of());
    }

    public static ParquetValueReader<RowData> buildReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        return (ParquetValueReader)TypeWithSchemaVisitor.visit(expectedSchema.asStruct(), fileSchema, new ReadBuilder(fileSchema, idToConstant));
    }

    private static class ReusableArrayData
    implements ArrayData {
        private static final Object[] EMPTY = new Object[0];
        private Object[] values = EMPTY;
        private int numElements = 0;

        private ReusableArrayData() {
        }

        private void grow() {
            if (this.values.length == 0) {
                this.values = new Object[20];
            } else {
                Object[] old = this.values;
                this.values = new Object[old.length << 1];
                System.arraycopy(old, 0, this.values, 0, old.length);
            }
        }

        private int capacity() {
            return this.values.length;
        }

        public void setNumElements(int numElements) {
            this.numElements = numElements;
        }

        public int size() {
            return this.numElements;
        }

        public boolean isNullAt(int ordinal) {
            return null == this.values[ordinal];
        }

        public boolean getBoolean(int ordinal) {
            return (Boolean)this.values[ordinal];
        }

        public byte getByte(int ordinal) {
            return (Byte)this.values[ordinal];
        }

        public short getShort(int ordinal) {
            return (Short)this.values[ordinal];
        }

        public int getInt(int ordinal) {
            return (Integer)this.values[ordinal];
        }

        public long getLong(int ordinal) {
            return (Long)this.values[ordinal];
        }

        public float getFloat(int ordinal) {
            return ((Float)this.values[ordinal]).floatValue();
        }

        public double getDouble(int ordinal) {
            return (Double)this.values[ordinal];
        }

        public StringData getString(int pos) {
            return (StringData)this.values[pos];
        }

        public DecimalData getDecimal(int pos, int precision, int scale) {
            return (DecimalData)this.values[pos];
        }

        public TimestampData getTimestamp(int pos, int precision) {
            return (TimestampData)this.values[pos];
        }

        public <T> RawValueData<T> getRawValue(int pos) {
            return (RawValueData)this.values[pos];
        }

        public byte[] getBinary(int ordinal) {
            return (byte[])this.values[ordinal];
        }

        public ArrayData getArray(int ordinal) {
            return (ArrayData)this.values[ordinal];
        }

        public MapData getMap(int ordinal) {
            return (MapData)this.values[ordinal];
        }

        public RowData getRow(int pos, int numFields) {
            return (RowData)this.values[pos];
        }

        public boolean[] toBooleanArray() {
            return ArrayUtil.toPrimitive((Boolean[])this.values);
        }

        public byte[] toByteArray() {
            return ArrayUtil.toPrimitive((Byte[])this.values);
        }

        public short[] toShortArray() {
            return ArrayUtil.toPrimitive((Short[])this.values);
        }

        public int[] toIntArray() {
            return ArrayUtil.toPrimitive((Integer[])this.values);
        }

        public long[] toLongArray() {
            return ArrayUtil.toPrimitive((Long[])this.values);
        }

        public float[] toFloatArray() {
            return ArrayUtil.toPrimitive((Float[])this.values);
        }

        public double[] toDoubleArray() {
            return ArrayUtil.toPrimitive((Double[])this.values);
        }
    }

    private static class ReusableMapData
    implements MapData {
        private final ReusableArrayData keys = new ReusableArrayData();
        private final ReusableArrayData values = new ReusableArrayData();
        private int numElements;

        private ReusableMapData() {
        }

        private void grow() {
            this.keys.grow();
            this.values.grow();
        }

        private int capacity() {
            return this.keys.capacity();
        }

        public void setNumElements(int numElements) {
            this.numElements = numElements;
            this.keys.setNumElements(numElements);
            this.values.setNumElements(numElements);
        }

        public int size() {
            return this.numElements;
        }

        public ReusableArrayData keyArray() {
            return this.keys;
        }

        public ReusableArrayData valueArray() {
            return this.values;
        }
    }

    private static class RowDataReader
    extends ParquetValueReaders.StructReader<RowData, GenericRowData> {
        private final int numFields;

        RowDataReader(List<Type> types, List<ParquetValueReader<?>> readers) {
            super(types, readers);
            this.numFields = readers.size();
        }

        @Override
        protected GenericRowData newStructData(RowData reuse) {
            if (reuse instanceof GenericRowData) {
                return (GenericRowData)reuse;
            }
            return new GenericRowData(this.numFields);
        }

        @Override
        protected Object getField(GenericRowData intermediate, int pos) {
            return intermediate.getField(pos);
        }

        @Override
        protected RowData buildStruct(GenericRowData struct) {
            return struct;
        }

        @Override
        protected void set(GenericRowData row, int pos, Object value) {
            row.setField(pos, value);
        }

        @Override
        protected void setNull(GenericRowData row, int pos) {
            row.setField(pos, null);
        }

        @Override
        protected void setBoolean(GenericRowData row, int pos, boolean value) {
            row.setField(pos, (Object)value);
        }

        @Override
        protected void setInteger(GenericRowData row, int pos, int value) {
            row.setField(pos, (Object)value);
        }

        @Override
        protected void setLong(GenericRowData row, int pos, long value) {
            row.setField(pos, (Object)value);
        }

        @Override
        protected void setFloat(GenericRowData row, int pos, float value) {
            row.setField(pos, (Object)Float.valueOf(value));
        }

        @Override
        protected void setDouble(GenericRowData row, int pos, double value) {
            row.setField(pos, (Object)value);
        }
    }

    private static class MapReader<K, V>
    extends ParquetValueReaders.RepeatedKeyValueReader<MapData, ReusableMapData, K, V> {
        private int readPos = 0;
        private int writePos = 0;
        private final ParquetValueReaders.ReusableEntry<K, V> entry = new ParquetValueReaders.ReusableEntry();
        private final ParquetValueReaders.ReusableEntry<K, V> nullEntry = new ParquetValueReaders.ReusableEntry();

        MapReader(int definitionLevel, int repetitionLevel, ParquetValueReader<K> keyReader, ParquetValueReader<V> valueReader) {
            super(definitionLevel, repetitionLevel, keyReader, valueReader);
        }

        @Override
        protected ReusableMapData newMapData(MapData reuse) {
            this.readPos = 0;
            this.writePos = 0;
            if (reuse instanceof ReusableMapData) {
                return (ReusableMapData)reuse;
            }
            return new ReusableMapData();
        }

        @Override
        protected Map.Entry<K, V> getPair(ReusableMapData map) {
            ParquetValueReaders.ReusableEntry<K, V> kv = this.nullEntry;
            if (this.readPos < map.capacity()) {
                this.entry.set(map.keys.values[this.readPos], map.values.values[this.readPos]);
                kv = this.entry;
            }
            ++this.readPos;
            return kv;
        }

        @Override
        protected void addPair(ReusableMapData map, K key, V value) {
            if (this.writePos >= map.capacity()) {
                map.grow();
            }
            ((ReusableArrayData)((ReusableMapData)map).keys).values[this.writePos] = key;
            ((ReusableArrayData)((ReusableMapData)map).values).values[this.writePos] = value;
            ++this.writePos;
        }

        @Override
        protected MapData buildMap(ReusableMapData map) {
            map.setNumElements(this.writePos);
            return map;
        }
    }

    private static class ArrayReader<E>
    extends ParquetValueReaders.RepeatedReader<ArrayData, ReusableArrayData, E> {
        private int readPos = 0;
        private int writePos = 0;

        ArrayReader(int definitionLevel, int repetitionLevel, ParquetValueReader<E> reader) {
            super(definitionLevel, repetitionLevel, reader);
        }

        @Override
        protected ReusableArrayData newListData(ArrayData reuse) {
            this.readPos = 0;
            this.writePos = 0;
            if (reuse instanceof ReusableArrayData) {
                return (ReusableArrayData)reuse;
            }
            return new ReusableArrayData();
        }

        @Override
        protected E getElement(ReusableArrayData list) {
            Object value = null;
            if (this.readPos < list.capacity()) {
                value = list.values[this.readPos];
            }
            ++this.readPos;
            return (E)value;
        }

        @Override
        protected void addElement(ReusableArrayData reused, E element) {
            if (this.writePos >= reused.capacity()) {
                reused.grow();
            }
            ((ReusableArrayData)reused).values[this.writePos] = element;
            ++this.writePos;
        }

        @Override
        protected ArrayData buildList(ReusableArrayData list) {
            return new GenericArrayData(Arrays.copyOf(list.values, this.writePos));
        }
    }

    private static class MillisTimeReader
    extends ParquetValueReaders.PrimitiveReader<Integer> {
        MillisTimeReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public Integer read(Integer reuse) {
            return (int)this.column.nextLong();
        }
    }

    private static class LossyMicrosToMillisTimeReader
    extends ParquetValueReaders.PrimitiveReader<Integer> {
        LossyMicrosToMillisTimeReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public Integer read(Integer reuse) {
            return (int)Math.floorDiv(this.column.nextLong(), 1000L);
        }
    }

    private static class StringReader
    extends ParquetValueReaders.PrimitiveReader<StringData> {
        StringReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public StringData read(StringData ignored) {
            Binary binary = this.column.nextBinary();
            ByteBuffer buffer = binary.toByteBuffer();
            if (buffer.hasArray()) {
                return StringData.fromBytes((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)buffer.remaining());
            }
            return StringData.fromBytes((byte[])binary.getBytes());
        }
    }

    private static class MillisToTimestampTzReader
    extends ParquetValueReaders.UnboxedReader<TimestampData> {
        MillisToTimestampTzReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public TimestampData read(TimestampData ignored) {
            long millis = this.readLong();
            return TimestampData.fromLocalDateTime((LocalDateTime)Instant.ofEpochMilli(millis).atOffset(ZoneOffset.UTC).toLocalDateTime());
        }

        @Override
        public long readLong() {
            return this.column.nextLong();
        }
    }

    private static class MillisToTimestampReader
    extends ParquetValueReaders.UnboxedReader<TimestampData> {
        MillisToTimestampReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public TimestampData read(TimestampData ignored) {
            long millis = this.readLong();
            return TimestampData.fromEpochMillis((long)millis);
        }

        @Override
        public long readLong() {
            return this.column.nextLong();
        }
    }

    private static class MicrosToTimestampReader
    extends ParquetValueReaders.UnboxedReader<TimestampData> {
        MicrosToTimestampReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public TimestampData read(TimestampData ignored) {
            long value = this.readLong();
            return TimestampData.fromInstant((Instant)Instant.ofEpochSecond(Math.floorDiv(value, 1000000L), Math.floorMod(value, 1000000L) * 1000L));
        }

        @Override
        public long readLong() {
            return this.column.nextLong();
        }
    }

    private static class MicrosToTimestampTzReader
    extends ParquetValueReaders.UnboxedReader<TimestampData> {
        MicrosToTimestampTzReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public TimestampData read(TimestampData ignored) {
            long value = this.readLong();
            return TimestampData.fromLocalDateTime((LocalDateTime)Instant.ofEpochSecond(Math.floorDiv(value, 1000000L), Math.floorMod(value, 1000000L) * 1000L).atOffset(ZoneOffset.UTC).toLocalDateTime());
        }

        @Override
        public long readLong() {
            return this.column.nextLong();
        }
    }

    private static class LongDecimalReader
    extends ParquetValueReaders.PrimitiveReader<DecimalData> {
        private final int precision;
        private final int scale;

        LongDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public DecimalData read(DecimalData ignored) {
            return DecimalData.fromUnscaledLong((long)this.column.nextLong(), (int)this.precision, (int)this.scale);
        }
    }

    private static class IntegerDecimalReader
    extends ParquetValueReaders.PrimitiveReader<DecimalData> {
        private final int precision;
        private final int scale;

        IntegerDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public DecimalData read(DecimalData ignored) {
            return DecimalData.fromUnscaledLong((long)this.column.nextInteger(), (int)this.precision, (int)this.scale);
        }
    }

    private static class BinaryDecimalReader
    extends ParquetValueReaders.PrimitiveReader<DecimalData> {
        private final int precision;
        private final int scale;

        BinaryDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public DecimalData read(DecimalData ignored) {
            Binary binary = this.column.nextBinary();
            BigDecimal bigDecimal = new BigDecimal(new BigInteger(binary.getBytes()), this.scale);
            return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)this.precision, (int)this.scale);
        }
    }

    private static class ReadBuilder
    extends TypeWithSchemaVisitor<ParquetValueReader<?>> {
        private final MessageType type;
        private final Map<Integer, ?> idToConstant;

        ReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            this.type = type;
            this.idToConstant = idToConstant;
        }

        @Override
        public ParquetValueReader<RowData> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return this.struct(expected, message.asGroupType(), (List)fieldReaders);
        }

        @Override
        public ParquetValueReader<RowData> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            HashMap<Integer, ParquetValueReader<?>> readersById = Maps.newHashMap();
            HashMap<Integer, Type> typesById = Maps.newHashMap();
            List<Type> fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                Type fieldType = fields.get(i);
                if (fieldReaders.get(i) == null) continue;
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                if (fieldType.getId() == null) continue;
                int id = fieldType.getId().intValue();
                readersById.put(id, ParquetValueReaders.option(fieldType, fieldD, fieldReaders.get(i)));
                typesById.put(id, fieldType);
            }
            List<Object> expectedFields = expected != null ? expected.fields() : ImmutableList.of();
            ArrayList<ParquetValueReader<?>> reorderedFields = Lists.newArrayListWithExpectedSize(expectedFields.size());
            ArrayList<Type> types = Lists.newArrayListWithExpectedSize(expectedFields.size());
            for (Types.NestedField nestedField : expectedFields) {
                int id = nestedField.fieldId();
                if (this.idToConstant.containsKey(id)) {
                    reorderedFields.add(ParquetValueReaders.constant(this.idToConstant.get(id)));
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.ROW_POSITION.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.position());
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.IS_DELETED.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.constant(false));
                    types.add(null);
                    continue;
                }
                ParquetValueReader reader = (ParquetValueReader)readersById.get(id);
                if (reader != null) {
                    reorderedFields.add(reader);
                    types.add((Type)typesById.get(id));
                    continue;
                }
                reorderedFields.add(ParquetValueReaders.nulls());
                types.add(null);
            }
            return new RowDataReader(types, reorderedFields);
        }

        @Override
        public ParquetValueReader<?> list(Types.ListType expectedList, GroupType array, ParquetValueReader<?> elementReader) {
            if (expectedList == null) {
                return null;
            }
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            Type elementType = ParquetSchemaUtil.determineListElementType(array);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName())) - 1;
            return new ArrayReader(repeatedD, repeatedR, ParquetValueReaders.option(elementType, elementD, elementReader));
        }

        @Override
        public ParquetValueReader<?> map(Types.MapType expectedMap, GroupType map, ParquetValueReader<?> keyReader, ParquetValueReader<?> valueReader) {
            if (expectedMap == null) {
                return null;
            }
            GroupType repeatedKeyValue = map.getFields().get(0).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName())) - 1;
            Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName())) - 1;
            return new MapReader(repeatedD, repeatedR, ParquetValueReaders.option(keyType, keyD, keyReader), ParquetValueReaders.option(valueType, valueD, valueReader));
        }

        @Override
        public ParquetValueReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
            if (expected == null) {
                return null;
            }
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        return new StringReader(desc);
                    }
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        if (expected.typeId() == Types.LongType.get().typeId()) {
                            return new ParquetValueReaders.IntAsLongReader(desc);
                        }
                        return new ParquetValueReaders.UnboxedReader(desc);
                    }
                    case TIME_MICROS: {
                        return new LossyMicrosToMillisTimeReader(desc);
                    }
                    case TIME_MILLIS: {
                        return new MillisTimeReader(desc);
                    }
                    case DATE: 
                    case INT_64: {
                        return new ParquetValueReaders.UnboxedReader(desc);
                    }
                    case TIMESTAMP_MICROS: {
                        if (((Types.TimestampType)expected).shouldAdjustToUTC()) {
                            return new MicrosToTimestampTzReader(desc);
                        }
                        return new MicrosToTimestampReader(desc);
                    }
                    case TIMESTAMP_MILLIS: {
                        if (((Types.TimestampType)expected).shouldAdjustToUTC()) {
                            return new MillisToTimestampTzReader(desc);
                        }
                        return new MillisToTimestampReader(desc);
                    }
                    case DECIMAL: {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)primitive.getLogicalTypeAnnotation();
                        switch (primitive.getPrimitiveTypeName()) {
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return new BinaryDecimalReader(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case INT64: {
                                return new LongDecimalReader(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case INT32: {
                                return new IntegerDecimalReader(desc, decimal.getPrecision(), decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + (Object)((Object)primitive.getPrimitiveTypeName()));
                    }
                    case BSON: {
                        return new ParquetValueReaders.ByteArrayReader(desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + (Object)((Object)primitive.getOriginalType()));
            }
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return new ParquetValueReaders.ByteArrayReader(desc);
                }
                case INT32: {
                    if (expected.typeId() == Type.TypeID.LONG) {
                        return new ParquetValueReaders.IntAsLongReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case FLOAT: {
                    if (expected.typeId() == Type.TypeID.DOUBLE) {
                        return new ParquetValueReaders.FloatAsDoubleReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case INT64: 
                case BOOLEAN: 
                case DOUBLE: {
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }
    }
}

