/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.data.FlinkAvroWriter;
import org.apache.iceberg.flink.data.FlinkOrcWriter;
import org.apache.iceberg.flink.data.FlinkParquetWriters;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class FlinkAppenderFactory
implements FileAppenderFactory<RowData>,
Serializable {
    private final Schema schema;
    private final RowType flinkSchema;
    private final Map<String, String> props;
    private final PartitionSpec spec;
    private final int[] equalityFieldIds;
    private final Schema eqDeleteRowSchema;
    private final Schema posDeleteRowSchema;
    private RowType eqDeleteFlinkSchema = null;
    private RowType posDeleteFlinkSchema = null;

    public FlinkAppenderFactory(Schema schema, RowType flinkSchema, Map<String, String> props, PartitionSpec spec) {
        this(schema, flinkSchema, props, spec, null, null, null);
    }

    public FlinkAppenderFactory(Schema schema, RowType flinkSchema, Map<String, String> props, PartitionSpec spec, int[] equalityFieldIds, Schema eqDeleteRowSchema, Schema posDeleteRowSchema) {
        this.schema = schema;
        this.flinkSchema = flinkSchema;
        this.props = props;
        this.spec = spec;
        this.equalityFieldIds = equalityFieldIds;
        this.eqDeleteRowSchema = eqDeleteRowSchema;
        this.posDeleteRowSchema = posDeleteRowSchema;
    }

    private RowType lazyEqDeleteFlinkSchema() {
        if (this.eqDeleteFlinkSchema == null) {
            Preconditions.checkNotNull(this.eqDeleteRowSchema, "Equality delete row schema shouldn't be null");
            this.eqDeleteFlinkSchema = FlinkSchemaUtil.convert(this.eqDeleteRowSchema);
        }
        return this.eqDeleteFlinkSchema;
    }

    private RowType lazyPosDeleteFlinkSchema() {
        if (this.posDeleteFlinkSchema == null) {
            Preconditions.checkNotNull(this.posDeleteRowSchema, "Pos-delete row schema shouldn't be null");
            this.posDeleteFlinkSchema = FlinkSchemaUtil.convert(this.posDeleteRowSchema);
        }
        return this.posDeleteFlinkSchema;
    }

    @Override
    public FileAppender<RowData> newAppender(OutputFile outputFile, FileFormat format) {
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.props);
        try {
            switch (format) {
                case AVRO: {
                    return Avro.write(outputFile).createWriterFunc(ignore -> new FlinkAvroWriter(this.flinkSchema)).setAll(this.props).schema(this.schema).metricsConfig(metricsConfig).overwrite().build();
                }
                case ORC: {
                    return ORC.write(outputFile).createWriterFunc((iSchema, typDesc) -> FlinkOrcWriter.buildWriter(this.flinkSchema, iSchema)).setAll(this.props).metricsConfig(metricsConfig).schema(this.schema).overwrite().build();
                }
                case PARQUET: {
                    return Parquet.write(outputFile).createWriterFunc(msgType -> FlinkParquetWriters.buildWriter((LogicalType)this.flinkSchema, msgType)).setAll(this.props).metricsConfig(metricsConfig).schema(this.schema).overwrite().build();
                }
            }
            throw new UnsupportedOperationException("Cannot write unknown file format: " + (Object)((Object)format));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public DataWriter<RowData> newDataWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        return new DataWriter<RowData>(this.newAppender(file.encryptingOutputFile(), format), format, file.encryptingOutputFile().location(), this.spec, partition, file.keyMetadata());
    }

    @Override
    public EqualityDeleteWriter<RowData> newEqDeleteWriter(EncryptedOutputFile outputFile, FileFormat format, StructLike partition) {
        Preconditions.checkState(this.equalityFieldIds != null && this.equalityFieldIds.length > 0, "Equality field ids shouldn't be null or empty when creating equality-delete writer");
        Preconditions.checkNotNull(this.eqDeleteRowSchema, "Equality delete row schema shouldn't be null when creating equality-delete writer");
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.props);
        try {
            switch (format) {
                case AVRO: {
                    return Avro.writeDeletes(outputFile.encryptingOutputFile()).createWriterFunc(ignore -> new FlinkAvroWriter(this.lazyEqDeleteFlinkSchema())).withPartition(partition).overwrite().setAll(this.props).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(outputFile.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
                case ORC: {
                    return ORC.writeDeletes(outputFile.encryptingOutputFile()).createWriterFunc((iSchema, typDesc) -> FlinkOrcWriter.buildWriter(this.flinkSchema, iSchema)).withPartition(partition).overwrite().setAll(this.props).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(outputFile.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
                case PARQUET: {
                    return Parquet.writeDeletes(outputFile.encryptingOutputFile()).createWriterFunc(msgType -> FlinkParquetWriters.buildWriter((LogicalType)this.lazyEqDeleteFlinkSchema(), msgType)).withPartition(partition).overwrite().setAll(this.props).metricsConfig(metricsConfig).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(outputFile.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write equality-deletes for unsupported file format: " + (Object)((Object)format));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PositionDeleteWriter<RowData> newPosDeleteWriter(EncryptedOutputFile outputFile, FileFormat format, StructLike partition) {
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.props);
        try {
            switch (format) {
                case AVRO: {
                    return Avro.writeDeletes(outputFile.encryptingOutputFile()).createWriterFunc(ignore -> new FlinkAvroWriter(this.lazyPosDeleteFlinkSchema())).withPartition(partition).overwrite().setAll(this.props).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(outputFile.keyMetadata()).buildPositionWriter();
                }
                case ORC: {
                    RowType orcPosDeleteSchema = FlinkSchemaUtil.convert(DeleteSchemaUtil.posDeleteSchema(this.posDeleteRowSchema));
                    return ORC.writeDeletes(outputFile.encryptingOutputFile()).createWriterFunc((iSchema, typDesc) -> FlinkOrcWriter.buildWriter(orcPosDeleteSchema, iSchema)).withPartition(partition).overwrite().setAll(this.props).metricsConfig(metricsConfig).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(outputFile.keyMetadata()).transformPaths(path -> StringData.fromString((String)path.toString())).buildPositionWriter();
                }
                case PARQUET: {
                    RowType flinkPosDeleteSchema = FlinkSchemaUtil.convert(DeleteSchemaUtil.posDeleteSchema(this.posDeleteRowSchema));
                    return Parquet.writeDeletes(outputFile.encryptingOutputFile()).createWriterFunc(msgType -> FlinkParquetWriters.buildWriter((LogicalType)flinkPosDeleteSchema, msgType)).withPartition(partition).overwrite().setAll(this.props).metricsConfig(metricsConfig).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(outputFile.keyMetadata()).transformPaths(path -> StringData.fromString((String)path.toString())).buildPositionWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write pos-deletes for unsupported file format: " + (Object)((Object)format));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

