/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.sink.FlinkAppenderFactory;
import org.apache.iceberg.flink.sink.PartitionedDeltaWriter;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.flink.sink.UnpartitionedDeltaWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitionedFanoutWriter;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.ArrayUtil;

public class RowDataTaskWriterFactory
implements TaskWriterFactory<RowData> {
    private final Table table;
    private final Schema schema;
    private final RowType flinkSchema;
    private final PartitionSpec spec;
    private final FileIO io;
    private final long targetFileSizeBytes;
    private final FileFormat format;
    private final List<Integer> equalityFieldIds;
    private final boolean upsert;
    private final FileAppenderFactory<RowData> appenderFactory;
    private transient OutputFileFactory outputFileFactory;

    public RowDataTaskWriterFactory(Table table, RowType flinkSchema, long targetFileSizeBytes, FileFormat format, List<Integer> equalityFieldIds, boolean upsert) {
        this.table = table;
        this.schema = table.schema();
        this.flinkSchema = flinkSchema;
        this.spec = table.spec();
        this.io = table.io();
        this.targetFileSizeBytes = targetFileSizeBytes;
        this.format = format;
        this.equalityFieldIds = equalityFieldIds;
        this.upsert = upsert;
        this.appenderFactory = equalityFieldIds == null || equalityFieldIds.isEmpty() ? new FlinkAppenderFactory(this.schema, flinkSchema, table.properties(), this.spec) : (upsert ? new FlinkAppenderFactory(this.schema, flinkSchema, table.properties(), this.spec, ArrayUtil.toIntArray(equalityFieldIds), TypeUtil.select(this.schema, Sets.newHashSet(equalityFieldIds)), null) : new FlinkAppenderFactory(this.schema, flinkSchema, table.properties(), this.spec, ArrayUtil.toIntArray(equalityFieldIds), this.schema, null));
    }

    @Override
    public void initialize(int taskId, int attemptId) {
        this.outputFileFactory = OutputFileFactory.builderFor(this.table, taskId, attemptId).format(this.format).build();
    }

    @Override
    public TaskWriter<RowData> create() {
        Preconditions.checkNotNull(this.outputFileFactory, "The outputFileFactory shouldn't be null if we have invoked the initialize().");
        if (this.equalityFieldIds == null || this.equalityFieldIds.isEmpty()) {
            if (this.spec.isUnpartitioned()) {
                return new UnpartitionedWriter<RowData>(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes);
            }
            return new RowDataPartitionedFanoutWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes, this.schema, this.flinkSchema);
        }
        if (this.spec.isUnpartitioned()) {
            return new UnpartitionedDeltaWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes, this.schema, this.flinkSchema, this.equalityFieldIds, this.upsert);
        }
        return new PartitionedDeltaWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes, this.schema, this.flinkSchema, this.equalityFieldIds, this.upsert);
    }

    private static class RowDataPartitionedFanoutWriter
    extends PartitionedFanoutWriter<RowData> {
        private final PartitionKey partitionKey;
        private final RowDataWrapper rowDataWrapper;

        RowDataPartitionedFanoutWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<RowData> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, RowType flinkSchema) {
            super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
            this.partitionKey = new PartitionKey(spec, schema);
            this.rowDataWrapper = new RowDataWrapper(flinkSchema, schema.asStruct());
        }

        @Override
        protected PartitionKey partition(RowData row) {
            this.partitionKey.partition(this.rowDataWrapper.wrap(row));
            return this.partitionKey;
        }
    }
}

