/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.source.FlinkSplitPlanner;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.assigner.SplitAssigner;
import org.apache.iceberg.flink.source.enumerator.AbstractIcebergEnumerator;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorState;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StaticIcebergEnumerator
extends AbstractIcebergEnumerator {
    private static final Logger LOG = LoggerFactory.getLogger(StaticIcebergEnumerator.class);
    private final SplitAssigner assigner;
    private final Table table;
    private final ScanContext scanContext;
    private final boolean shouldEnumerate;

    public StaticIcebergEnumerator(SplitEnumeratorContext<IcebergSourceSplit> enumeratorContext, SplitAssigner assigner, Table table, ScanContext scanContext, @Nullable IcebergEnumeratorState enumState) {
        super(enumeratorContext, assigner);
        this.assigner = assigner;
        this.table = table;
        this.scanContext = scanContext;
        this.shouldEnumerate = enumState == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        super.start();
        if (this.shouldEnumerate) {
            String threadName = "iceberg-plan-worker-pool-" + this.table.name() + "-" + UUID.randomUUID();
            ExecutorService workerPool = ThreadPools.newWorkerPool(threadName, this.scanContext.planParallelism());
            try {
                List<IcebergSourceSplit> splits = FlinkSplitPlanner.planIcebergSourceSplits(this.table, this.scanContext, workerPool);
                this.assigner.onDiscoveredSplits(splits);
                LOG.info("Discovered {} splits from table {} during job initialization", (Object)splits.size(), (Object)this.table.name());
            }
            finally {
                workerPool.shutdown();
            }
        }
    }

    @Override
    protected boolean shouldWaitForMoreSplits() {
        return false;
    }

    public IcebergEnumeratorState snapshotState(long checkpointId) {
        return new IcebergEnumeratorState(null, this.assigner.state());
    }
}

