/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.iceberg.flink.source.reader.IcebergSourceRecordEmitter;
import org.apache.iceberg.flink.source.reader.IcebergSourceSplitReader;
import org.apache.iceberg.flink.source.reader.ReaderFunction;
import org.apache.iceberg.flink.source.reader.ReaderMetricsContext;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.SplitRequestEvent;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class IcebergSourceReader<T>
extends SingleThreadMultiplexSourceReaderBase<RecordAndPosition<T>, T, IcebergSourceSplit, IcebergSourceSplit> {
    public IcebergSourceReader(ReaderFunction<T> readerFunction, SourceReaderContext context, ReaderMetricsContext metrics) {
        super(() -> new IcebergSourceSplitReader(readerFunction, context, metrics), new IcebergSourceRecordEmitter(), context.getConfiguration(), context);
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.requestSplit(Collections.emptyList());
        }
    }

    protected void onSplitFinished(Map<String, IcebergSourceSplit> finishedSplitIds) {
        this.requestSplit(Lists.newArrayList(finishedSplitIds.keySet()));
    }

    protected IcebergSourceSplit initializedState(IcebergSourceSplit split) {
        return split;
    }

    protected IcebergSourceSplit toSplitType(String splitId, IcebergSourceSplit splitState) {
        return splitState;
    }

    private void requestSplit(Collection<String> finishedSplitIds) {
        this.context.sendSourceEventToCoordinator((SourceEvent)new SplitRequestEvent(finishedSplitIds));
    }
}

