/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.RowDataFileScanTaskReader;
import org.apache.iceberg.flink.source.reader.ArrayPoolDataIteratorBatcher;
import org.apache.iceberg.flink.source.reader.DataIteratorReaderFunction;
import org.apache.iceberg.flink.source.reader.RowDataRecordFactory;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class RowDataReaderFunction
extends DataIteratorReaderFunction<RowData> {
    private final Schema tableSchema;
    private final Schema readSchema;
    private final String nameMapping;
    private final boolean caseSensitive;
    private final FileIO io;
    private final EncryptionManager encryption;

    public RowDataReaderFunction(ReadableConfig config, Schema tableSchema, Schema projectedSchema, String nameMapping, boolean caseSensitive, FileIO io, EncryptionManager encryption) {
        super(new ArrayPoolDataIteratorBatcher<RowData>(config, new RowDataRecordFactory(FlinkSchemaUtil.convert(RowDataReaderFunction.readSchema(tableSchema, projectedSchema)))));
        this.tableSchema = tableSchema;
        this.readSchema = RowDataReaderFunction.readSchema(tableSchema, projectedSchema);
        this.nameMapping = nameMapping;
        this.caseSensitive = caseSensitive;
        this.io = io;
        this.encryption = encryption;
    }

    @Override
    public DataIterator<RowData> createDataIterator(IcebergSourceSplit split) {
        return new DataIterator<RowData>(new RowDataFileScanTaskReader(this.tableSchema, this.readSchema, this.nameMapping, this.caseSensitive), split.task(), this.io, this.encryption);
    }

    private static Schema readSchema(Schema tableSchema, Schema projectedSchema) {
        Preconditions.checkNotNull(tableSchema, "Table schema can't be null");
        return projectedSchema == null ? tableSchema : projectedSchema;
    }
}

