/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.JdbcUtil;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcTableOperations.class);
    private final String catalogName;
    private final TableIdentifier tableIdentifier;
    private final FileIO fileIO;
    private final JdbcClientPool connections;

    protected JdbcTableOperations(JdbcClientPool dbConnPool, FileIO fileIO, String catalogName, TableIdentifier tableIdentifier) {
        this.catalogName = catalogName;
        this.tableIdentifier = tableIdentifier;
        this.fileIO = fileIO;
        this.connections = dbConnPool;
    }

    @Override
    public void doRefresh() {
        Map<String, String> table;
        try {
            table = this.getTable();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted during refresh", new Object[0]);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to get table %s from catalog %s", this.tableIdentifier, this.catalogName);
        }
        if (table.isEmpty()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException("Failed to load table %s from catalog %s: dropped by another process", this.tableIdentifier, this.catalogName);
            }
            this.disableRefresh();
            return;
        }
        String newMetadataLocation = table.get("metadata_location");
        Preconditions.checkState(newMetadataLocation != null, "Invalid table %s: metadata location is null", (Object)this.tableIdentifier);
        this.refreshFromMetadataLocation(newMetadataLocation);
    }

    @Override
    public void doCommit(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        try {
            Map<String, String> table = this.getTable();
            if (base != null) {
                this.validateMetadataLocation(table, base);
                String oldMetadataLocation = base.metadataFileLocation();
                LOG.debug("Committing existing table: {}", (Object)this.tableName());
                this.updateTable(newMetadataLocation, oldMetadataLocation);
            } else {
                LOG.debug("Committing new table: {}", (Object)this.tableName());
                this.createTable(newMetadataLocation);
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            if (this.currentMetadataLocation() == null) {
                throw new AlreadyExistsException(e, "Table already exists: %s", this.tableIdentifier);
            }
            throw new UncheckedSQLException(e, "Table already exists: %s", this.tableIdentifier);
        }
        catch (SQLTimeoutException e) {
            throw new UncheckedSQLException(e, "Database Connection timeout", new Object[0]);
        }
        catch (SQLNonTransientConnectionException | SQLTransientConnectionException e) {
            throw new UncheckedSQLException(e, "Database Connection failed", new Object[0]);
        }
        catch (DataTruncation e) {
            throw new UncheckedSQLException(e, "Database data truncation error", new Object[0]);
        }
        catch (SQLWarning e) {
            throw new UncheckedSQLException(e, "Database warning", new Object[0]);
        }
        catch (SQLException e) {
            if (e.getMessage().contains("constraint failed")) {
                throw new AlreadyExistsException("Table already exists: %s", this.tableIdentifier);
            }
            throw new UncheckedSQLException(e, "Unknown failure", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted during commit", new Object[0]);
        }
    }

    private void updateTable(String newMetadataLocation, String oldMetadataLocation) throws SQLException, InterruptedException {
        int updatedRecords = this.connections.run(conn -> {
            try (PreparedStatement sql = conn.prepareStatement("UPDATE iceberg_tables SET metadata_location = ? , previous_metadata_location = ?  WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND metadata_location = ?");){
                sql.setString(1, newMetadataLocation);
                sql.setString(2, oldMetadataLocation);
                sql.setString(3, this.catalogName);
                sql.setString(4, JdbcUtil.namespaceToString(this.tableIdentifier.namespace()));
                sql.setString(5, this.tableIdentifier.name());
                sql.setString(6, oldMetadataLocation);
                Integer n = sql.executeUpdate();
                return n;
            }
        });
        if (updatedRecords != 1) {
            throw new CommitFailedException("Failed to update table %s from catalog %s", this.tableIdentifier, this.catalogName);
        }
        LOG.debug("Successfully committed to existing table: {}", (Object)this.tableIdentifier);
    }

    private void createTable(String newMetadataLocation) throws SQLException, InterruptedException {
        int insertRecord = this.connections.run(conn -> {
            try (PreparedStatement sql = conn.prepareStatement("INSERT INTO iceberg_tables (catalog_name, table_namespace, table_name, metadata_location, previous_metadata_location)  VALUES (?,?,?,?,null)");){
                sql.setString(1, this.catalogName);
                sql.setString(2, JdbcUtil.namespaceToString(this.tableIdentifier.namespace()));
                sql.setString(3, this.tableIdentifier.name());
                sql.setString(4, newMetadataLocation);
                Integer n = sql.executeUpdate();
                return n;
            }
        });
        if (insertRecord != 1) {
            throw new CommitFailedException("Failed to create table %s in catalog %s", this.tableIdentifier, this.catalogName);
        }
        LOG.debug("Successfully committed to new table: {}", (Object)this.tableIdentifier);
    }

    private void validateMetadataLocation(Map<String, String> table, TableMetadata base) {
        String baseMetadataLocation;
        String catalogMetadataLocation = table.get("metadata_location");
        String string = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
        if (!Objects.equals(baseMetadataLocation, catalogMetadataLocation)) {
            throw new CommitFailedException("Cannot commit %s: metadata location %s has changed from %s", this.tableIdentifier, baseMetadataLocation, catalogMetadataLocation);
        }
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }

    @Override
    protected String tableName() {
        return this.tableIdentifier.toString();
    }

    private Map<String, String> getTable() throws UncheckedSQLException, SQLException, InterruptedException {
        return this.connections.run(conn -> {
            HashMap<String, String> table = Maps.newHashMap();
            try (PreparedStatement sql = conn.prepareStatement("SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? ");){
                sql.setString(1, this.catalogName);
                sql.setString(2, JdbcUtil.namespaceToString(this.tableIdentifier.namespace()));
                sql.setString(3, this.tableIdentifier.name());
                ResultSet rs = sql.executeQuery();
                if (rs.next()) {
                    table.put("catalog_name", rs.getString("catalog_name"));
                    table.put("table_namespace", rs.getString("table_namespace"));
                    table.put("table_name", rs.getString("table_name"));
                    table.put("metadata_location", rs.getString("metadata_location"));
                    table.put("previous_metadata_location", rs.getString("previous_metadata_location"));
                }
                rs.close();
            }
            return table;
        });
    }
}

