/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.BytesInput;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.CodecFactory;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.codec.ZstandardCodec;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class ParquetCodecFactory
extends CodecFactory {
    public ParquetCodecFactory(Configuration configuration, int pageSize) {
        super(configuration, pageSize);
    }

    @Override
    protected CodecFactory.BytesDecompressor createDecompressor(CompressionCodecName codecName) {
        return new HeapBytesDecompressor(codecName);
    }

    class HeapBytesDecompressor
    extends CodecFactory.BytesDecompressor {
        private final CompressionCodec codec;
        private final Decompressor decompressor;

        HeapBytesDecompressor(CompressionCodecName codecName) {
            this.codec = ParquetCodecFactory.this.getCodec(codecName);
            this.decompressor = this.codec != null ? CodecPool.getDecompressor((CompressionCodec)this.codec) : null;
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            BytesInput decompressed;
            if (this.codec != null) {
                if (this.decompressor != null) {
                    this.decompressor.reset();
                }
                if (this.codec instanceof ZstandardCodec) {
                    try (CompressionInputStream is = this.codec.createInputStream((InputStream)bytes.toInputStream(), this.decompressor);){
                        decompressed = BytesInput.copy(BytesInput.from((InputStream)is, uncompressedSize));
                    }
                } else {
                    CompressionInputStream is = this.codec.createInputStream((InputStream)bytes.toInputStream(), this.decompressor);
                    decompressed = BytesInput.from((InputStream)is, uncompressedSize);
                }
            } else {
                decompressed = bytes;
            }
            return decompressed;
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
            ByteBuffer decompressed = this.decompress(BytesInput.from(input), uncompressedSize).toByteBuffer();
            output.put(decompressed);
        }

        @Override
        public void release() {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
            }
        }
    }
}

