/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.io.airlift.compress.snappy;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.iceberg.shaded.io.airlift.compress.Decompressor;
import org.apache.iceberg.shaded.io.airlift.compress.MalformedInputException;
import org.apache.iceberg.shaded.io.airlift.compress.snappy.SnappyRawDecompressor;
import org.apache.iceberg.shaded.io.airlift.compress.snappy.UnsafeUtil;
import sun.misc.Unsafe;

public class SnappyDecompressor
implements Decompressor {
    public static int getUncompressedLength(byte[] compressed, int compressedOffset) {
        long compressedAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressedOffset;
        long compressedLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressed.length;
        return SnappyRawDecompressor.getUncompressedLength(compressed, compressedAddress, compressedLimit);
    }

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return SnappyRawDecompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(ByteBuffer inputBuffer, ByteBuffer outputBuffer) throws MalformedInputException {
        long outputLimit;
        long outputAddress;
        Object outputBase;
        long inputLimit;
        long inputAddress;
        Object inputBase;
        ByteBuffer input = inputBuffer;
        ByteBuffer output = outputBuffer;
        if (((Buffer)input).isDirect()) {
            inputBase = null;
            long address = UnsafeUtil.getAddress(input);
            inputAddress = address + (long)input.position();
            inputLimit = address + (long)input.limit();
        } else if (((Buffer)input).hasArray()) {
            inputBase = ((Buffer)input).array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (((Buffer)output).isDirect()) {
            outputBase = null;
            long address = UnsafeUtil.getAddress(output);
            outputAddress = address + (long)output.position();
            outputLimit = address + (long)output.limit();
        } else if (((Buffer)output).hasArray()) {
            outputBase = ((Buffer)output).array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output).arrayOffset() + output.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output).arrayOffset() + output.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output;
            synchronized (byteBuffer2) {
                int written = SnappyRawDecompressor.decompress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit);
                ((Buffer)output).position(output.position() + written);
            }
        }
    }
}

