/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.BytesUtils;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.ValuesReader;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.iceberg.shaded.org.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBitPackingValuesReader
extends ValuesReader {
    private static final int VALUES_AT_A_TIME = 8;
    private static final Logger LOG = LoggerFactory.getLogger(ByteBitPackingValuesReader.class);
    private final int bitWidth;
    private final BytePacker packer;
    private final int[] decoded = new int[8];
    private int decodedPosition = 7;
    private ByteBufferInputStream in;

    public ByteBitPackingValuesReader(int bound, Packer packer) {
        this.bitWidth = BytesUtils.getWidthFromMaxInt(bound);
        this.packer = packer.newBytePacker(this.bitWidth);
    }

    @Override
    public int readInteger() {
        ++this.decodedPosition;
        if (this.decodedPosition == this.decoded.length) {
            try {
                if (this.in.available() < this.bitWidth) {
                    byte[] tempEncode = new byte[this.bitWidth];
                    this.in.read(tempEncode, 0, this.in.available());
                    this.packer.unpack8Values(tempEncode, 0, this.decoded, 0);
                } else {
                    ByteBuffer encoded = this.in.slice(this.bitWidth);
                    this.packer.unpack8Values(encoded, encoded.position(), this.decoded, 0);
                }
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Failed to read packed values", e);
            }
            this.decodedPosition = 0;
        }
        return this.decoded[this.decodedPosition];
    }

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        int effectiveBitLength = valueCount * this.bitWidth;
        int length = BytesUtils.paddedByteCountFromBits(effectiveBitLength);
        LOG.debug("reading {} bytes for {} values of size {} bits.", new Object[]{length, valueCount, this.bitWidth});
        length = Math.min(length, stream.available());
        this.in = stream.sliceStream(length);
        this.decodedPosition = 7;
        this.updateNextOffset(length);
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

