/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class PartitionUtil {
    private PartitionUtil() {
    }

    public static Map<Integer, ?> constantsMap(FileScanTask task) {
        return PartitionUtil.constantsMap(task, null, (type, constant) -> constant);
    }

    public static Map<Integer, ?> constantsMap(FileScanTask task, BiFunction<Type, Object, Object> convertConstant) {
        return PartitionUtil.constantsMap(task, null, convertConstant);
    }

    public static Map<Integer, ?> constantsMap(FileScanTask task, Types.StructType partitionType, BiFunction<Type, Object, Object> convertConstant) {
        PartitionSpec spec = task.spec();
        StructLike partitionData = ((DataFile)task.file()).partition();
        HashMap<Integer, Object> idToConstant = Maps.newHashMap();
        idToConstant.put(MetadataColumns.FILE_PATH.fieldId(), convertConstant.apply(Types.StringType.get(), ((DataFile)task.file()).path()));
        idToConstant.put(MetadataColumns.SPEC_ID.fieldId(), convertConstant.apply(Types.IntegerType.get(), ((DataFile)task.file()).specId()));
        if (partitionType != null) {
            if (partitionType.fields().size() > 0) {
                StructLike coercedPartition = PartitionUtil.coercePartition(partitionType, spec, partitionData);
                idToConstant.put(0x7FFFFFFA, convertConstant.apply(partitionType, coercedPartition));
            } else {
                idToConstant.put(0x7FFFFFFA, null);
            }
        }
        List<Types.NestedField> partitionFields = spec.partitionType().fields();
        List<PartitionField> fields = spec.fields();
        for (int pos = 0; pos < fields.size(); ++pos) {
            PartitionField field = fields.get(pos);
            if (!field.transform().isIdentity()) continue;
            Object converted = convertConstant.apply(partitionFields.get(pos).type(), partitionData.get(pos, Object.class));
            idToConstant.put(field.sourceId(), converted);
        }
        return idToConstant;
    }

    private static StructLike coercePartition(Types.StructType partitionType, PartitionSpec spec, StructLike partition) {
        StructProjection projection = StructProjection.createAllowMissing(spec.partitionType(), partitionType);
        projection.wrap(partition);
        return projection;
    }
}

