/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpRuntimeConfig;
import org.projectnessie.client.http.HttpUtils;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;

public class HttpClient {
    private final HttpRuntimeConfig config;

    private HttpClient(HttpRuntimeConfig config) {
        this.config = config;
    }

    public HttpRequest newRequest() {
        return new HttpRequest(this.config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI getBaseUri() {
        return this.config.getBaseUri();
    }

    public static class Builder {
        private URI baseUri;
        private ObjectMapper mapper;
        private SSLContext sslContext;
        private int readTimeoutMillis = Integer.parseInt(System.getProperty("sun.net.client.defaultReadTimeout", "25000"));
        private int connectionTimeoutMillis = Integer.parseInt(System.getProperty("sun.net.client.defaultConnectionTimeout", "5000"));
        private boolean disableCompression;
        private final List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();

        private Builder() {
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public Builder setBaseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder setDisableCompression(boolean disableCompression) {
            this.disableCompression = disableCompression;
            return this;
        }

        public Builder setObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setReadTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder setConnectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder addRequestFilter(RequestFilter filter) {
            this.requestFilters.add(filter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter filter) {
            this.responseFilters.add(filter);
            return this;
        }

        public HttpClient build() {
            HttpUtils.checkArgument(this.baseUri != null, "Cannot construct Http client. Must have a non-null uri", new Object[0]);
            HttpUtils.checkArgument(this.mapper != null, "Cannot construct Http client. Must have a non-null object mapper", new Object[0]);
            if (this.sslContext == null) {
                try {
                    this.sslContext = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new HttpClientException("Cannot construct Http Client. Default SSL config is invalid.", e);
                }
            }
            return new HttpClient(new HttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.disableCompression, this.sslContext, this.requestFilters, this.responseFilters));
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

