/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.BaseMergeTransplant;
import org.projectnessie.model.ContentKey;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BaseMergeTransplant.MergeKeyBehavior", generator="Immutables")
@Immutable
public final class ImmutableMergeKeyBehavior
implements BaseMergeTransplant.MergeKeyBehavior {
    private final ContentKey key;
    private final BaseMergeTransplant.MergeBehavior mergeBehavior;

    private ImmutableMergeKeyBehavior(ContentKey key, BaseMergeTransplant.MergeBehavior mergeBehavior) {
        this.key = key;
        this.mergeBehavior = mergeBehavior;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="mergeBehavior")
    public BaseMergeTransplant.MergeBehavior getMergeBehavior() {
        return this.mergeBehavior;
    }

    public final ImmutableMergeKeyBehavior withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableMergeKeyBehavior(newValue, this.mergeBehavior);
    }

    public final ImmutableMergeKeyBehavior withMergeBehavior(BaseMergeTransplant.MergeBehavior value) {
        BaseMergeTransplant.MergeBehavior newValue = Objects.requireNonNull(value, "mergeBehavior");
        if (this.mergeBehavior == newValue) {
            return this;
        }
        return new ImmutableMergeKeyBehavior(this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeKeyBehavior && this.equalTo(0, (ImmutableMergeKeyBehavior)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeKeyBehavior another) {
        return this.key.equals(another.key) && this.mergeBehavior.equals((Object)another.mergeBehavior);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.key.hashCode();
        h2 += (h2 << 5) + this.mergeBehavior.hashCode();
        return h2;
    }

    public String toString() {
        return "MergeKeyBehavior{key=" + this.key + ", mergeBehavior=" + (Object)((Object)this.mergeBehavior) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMergeKeyBehavior fromJson(Json json) {
        Builder builder = ImmutableMergeKeyBehavior.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.mergeBehavior != null) {
            builder.mergeBehavior(json.mergeBehavior);
        }
        return builder.build();
    }

    public static ImmutableMergeKeyBehavior copyOf(BaseMergeTransplant.MergeKeyBehavior instance) {
        if (instance instanceof ImmutableMergeKeyBehavior) {
            return (ImmutableMergeKeyBehavior)instance;
        }
        return ImmutableMergeKeyBehavior.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BaseMergeTransplant.MergeKeyBehavior", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_MERGE_BEHAVIOR = 2L;
        private long initBits = 3L;
        @Nullable
        private ContentKey key;
        @Nullable
        private BaseMergeTransplant.MergeBehavior mergeBehavior;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseMergeTransplant.MergeKeyBehavior instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.mergeBehavior(instance.getMergeBehavior());
            return this;
        }

        @JsonProperty(value="key")
        @CanIgnoreReturnValue
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="mergeBehavior")
        @CanIgnoreReturnValue
        public final Builder mergeBehavior(BaseMergeTransplant.MergeBehavior mergeBehavior) {
            this.mergeBehavior = Objects.requireNonNull(mergeBehavior, "mergeBehavior");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMergeKeyBehavior build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mergeBehavior");
            }
            return "Cannot build MergeKeyBehavior, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BaseMergeTransplant.MergeKeyBehavior", generator="Immutables")
    static final class Json
    implements BaseMergeTransplant.MergeKeyBehavior {
        @Nullable
        ContentKey key;
        @Nullable
        BaseMergeTransplant.MergeBehavior mergeBehavior;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="mergeBehavior")
        public void setMergeBehavior(BaseMergeTransplant.MergeBehavior mergeBehavior) {
            this.mergeBehavior = mergeBehavior;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseMergeTransplant.MergeBehavior getMergeBehavior() {
            throw new UnsupportedOperationException();
        }
    }
}

