/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.CharSequenceSet;

class BaseRowDelta
extends MergingSnapshotProducer<RowDelta>
implements RowDelta {
    private Long startingSnapshotId = null;
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private boolean validateDeletes = false;
    private Expression conflictDetectionFilter = Expressions.alwaysTrue();
    private boolean validateNewDataFiles = false;
    private boolean validateNewDeleteFiles = false;

    BaseRowDelta(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected BaseRowDelta self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    @Override
    public RowDelta addRows(DataFile inserts) {
        this.add(inserts);
        return this;
    }

    @Override
    public RowDelta addDeletes(DeleteFile deletes) {
        this.add(deletes);
        return this;
    }

    @Override
    public RowDelta validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    @Override
    public RowDelta validateDeletedFiles() {
        this.validateDeletes = true;
        return this;
    }

    @Override
    public RowDelta validateDataFilesExist(Iterable<? extends CharSequence> referencedFiles) {
        referencedFiles.forEach(this.referencedDataFiles::add);
        return this;
    }

    @Override
    public RowDelta conflictDetectionFilter(Expression newConflictDetectionFilter) {
        Preconditions.checkArgument(newConflictDetectionFilter != null, "Conflict detection filter cannot be null");
        this.conflictDetectionFilter = newConflictDetectionFilter;
        return this;
    }

    @Override
    public RowDelta validateNoConflictingDataFiles() {
        this.validateNewDataFiles = true;
        return this;
    }

    @Override
    public RowDelta validateNoConflictingDeleteFiles() {
        this.validateNewDeleteFiles = true;
        return this;
    }

    @Override
    protected void validate(TableMetadata base, Snapshot snapshot) {
        if (base.currentSnapshot() != null) {
            if (!this.referencedDataFiles.isEmpty()) {
                this.validateDataFilesExist(base, this.startingSnapshotId, this.referencedDataFiles, !this.validateDeletes, this.conflictDetectionFilter);
            }
            if (this.validateNewDataFiles) {
                this.validateAddedDataFiles(base, this.startingSnapshotId, this.conflictDetectionFilter);
            }
            if (this.validateNewDeleteFiles) {
                this.validateNoNewDeleteFiles(base, this.startingSnapshotId, this.conflictDetectionFilter);
            }
        }
    }
}

