/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;

public class SnapshotParser {
    private static final DummyFileIO DUMMY_FILE_IO = new DummyFileIO();
    private static final String SEQUENCE_NUMBER = "sequence-number";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String PARENT_SNAPSHOT_ID = "parent-snapshot-id";
    private static final String TIMESTAMP_MS = "timestamp-ms";
    private static final String SUMMARY = "summary";
    private static final String OPERATION = "operation";
    private static final String MANIFESTS = "manifests";
    private static final String MANIFEST_LIST = "manifest-list";
    private static final String SCHEMA_ID = "schema-id";

    private SnapshotParser() {
    }

    static void toJson(Snapshot snapshot, JsonGenerator generator) throws IOException {
        String manifestList;
        generator.writeStartObject();
        if (snapshot.sequenceNumber() > 0L) {
            generator.writeNumberField(SEQUENCE_NUMBER, snapshot.sequenceNumber());
        }
        generator.writeNumberField(SNAPSHOT_ID, snapshot.snapshotId());
        if (snapshot.parentId() != null) {
            generator.writeNumberField(PARENT_SNAPSHOT_ID, snapshot.parentId());
        }
        generator.writeNumberField(TIMESTAMP_MS, snapshot.timestampMillis());
        if (snapshot.operation() != null) {
            generator.writeObjectFieldStart(SUMMARY);
            generator.writeStringField(OPERATION, snapshot.operation());
            if (snapshot.summary() != null) {
                for (Map.Entry<String, String> entry : snapshot.summary().entrySet()) {
                    if (OPERATION.equals(entry.getKey())) continue;
                    generator.writeStringField(entry.getKey(), entry.getValue());
                }
            }
            generator.writeEndObject();
        }
        if ((manifestList = snapshot.manifestListLocation()) != null) {
            generator.writeStringField(MANIFEST_LIST, manifestList);
        } else {
            JsonUtil.writeStringArray(MANIFESTS, Iterables.transform(snapshot.allManifests(DUMMY_FILE_IO), ManifestFile::path), generator);
        }
        if (snapshot.schemaId() != null) {
            generator.writeNumberField(SCHEMA_ID, snapshot.schemaId());
        }
        generator.writeEndObject();
    }

    public static String toJson(Snapshot snapshot) {
        return SnapshotParser.toJson(snapshot, true);
    }

    public static String toJson(Snapshot snapshot, boolean pretty) {
        return JsonUtil.generate(gen -> SnapshotParser.toJson(snapshot, gen), pretty);
    }

    static Snapshot fromJson(JsonNode node) {
        Preconditions.checkArgument(node.isObject(), "Cannot parse table version from a non-object: %s", (Object)node);
        long sequenceNumber = 0L;
        if (node.has(SEQUENCE_NUMBER)) {
            sequenceNumber = JsonUtil.getLong(SEQUENCE_NUMBER, node);
        }
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        Long parentId = null;
        if (node.has(PARENT_SNAPSHOT_ID)) {
            parentId = JsonUtil.getLong(PARENT_SNAPSHOT_ID, node);
        }
        long timestamp = JsonUtil.getLong(TIMESTAMP_MS, node);
        ImmutableMap<String, String> summary = null;
        String operation = null;
        if (node.has(SUMMARY)) {
            JsonNode sNode = node.get(SUMMARY);
            Preconditions.checkArgument(sNode != null && !sNode.isNull() && sNode.isObject(), "Cannot parse summary from non-object value: %s", (Object)sNode);
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            Iterator<String> fields = sNode.fieldNames();
            while (fields.hasNext()) {
                String field = fields.next();
                if (field.equals(OPERATION)) {
                    operation = JsonUtil.getString(OPERATION, sNode);
                    continue;
                }
                builder.put(field, JsonUtil.getString(field, sNode));
            }
            summary = builder.build();
        }
        Integer schemaId = JsonUtil.getIntOrNull(SCHEMA_ID, node);
        if (node.has(MANIFEST_LIST)) {
            String manifestList = JsonUtil.getString(MANIFEST_LIST, node);
            return new BaseSnapshot(sequenceNumber, snapshotId, parentId, timestamp, operation, summary, schemaId, manifestList);
        }
        return new BaseSnapshot(sequenceNumber, snapshotId, parentId, timestamp, operation, summary, schemaId, JsonUtil.getStringList(MANIFESTS, node).toArray(new String[0]));
    }

    public static Snapshot fromJson(String json) {
        try {
            return SnapshotParser.fromJson(JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read version from json: %s", json);
        }
    }

    private static class DummyFileIO
    implements FileIO {
        private DummyFileIO() {
        }

        @Override
        public InputFile newInputFile(final String path) {
            return new InputFile(){

                @Override
                public long getLength() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public SeekableInputStream newStream() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String location() {
                    return path;
                }

                @Override
                public boolean exists() {
                    return true;
                }
            };
        }

        @Override
        public OutputFile newOutputFile(String path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteFile(String path) {
            throw new UnsupportedOperationException();
        }
    }
}

