/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.util.StringUtils;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.FlinkDynamicTableFactory;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.util.FlinkCompatibilityUtil;
import org.apache.iceberg.flink.util.FlinkPackage;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

public class FlinkCatalog
extends AbstractCatalog {
    private final CatalogLoader catalogLoader;
    private final Catalog icebergCatalog;
    private final Namespace baseNamespace;
    private final SupportsNamespaces asNamespaceCatalog;
    private final Closeable closeable;
    private final boolean cacheEnabled;

    public FlinkCatalog(String catalogName, String defaultDatabase, Namespace baseNamespace, CatalogLoader catalogLoader, boolean cacheEnabled, long cacheExpirationIntervalMs) {
        super(catalogName, defaultDatabase);
        this.catalogLoader = catalogLoader;
        this.baseNamespace = baseNamespace;
        this.cacheEnabled = cacheEnabled;
        Catalog originalCatalog = catalogLoader.loadCatalog();
        this.icebergCatalog = cacheEnabled ? CachingCatalog.wrap(originalCatalog, cacheExpirationIntervalMs) : originalCatalog;
        this.asNamespaceCatalog = originalCatalog instanceof SupportsNamespaces ? (SupportsNamespaces)((Object)originalCatalog) : null;
        this.closeable = originalCatalog instanceof Closeable ? (Closeable)((Object)originalCatalog) : null;
        EnvironmentContext.put("engine-name", "flink");
        EnvironmentContext.put("engine-version", FlinkPackage.version());
    }

    public void open() throws CatalogException {
        try {
            this.createDatabase(this.getDefaultDatabase(), ImmutableMap.of(), true);
        }
        catch (DatabaseAlreadyExistException databaseAlreadyExistException) {
            // empty catch block
        }
    }

    public void close() throws CatalogException {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException e) {
                throw new CatalogException((Throwable)e);
            }
        }
    }

    public Catalog catalog() {
        return this.icebergCatalog;
    }

    private Namespace toNamespace(String database) {
        String[] namespace = new String[this.baseNamespace.levels().length + 1];
        System.arraycopy(this.baseNamespace.levels(), 0, namespace, 0, this.baseNamespace.levels().length);
        namespace[this.baseNamespace.levels().length] = database;
        return Namespace.of(namespace);
    }

    TableIdentifier toIdentifier(ObjectPath path) {
        return TableIdentifier.of(this.toNamespace(path.getDatabaseName()), path.getObjectName());
    }

    public List<String> listDatabases() throws CatalogException {
        if (this.asNamespaceCatalog == null) {
            return Collections.singletonList(this.getDefaultDatabase());
        }
        return this.asNamespaceCatalog.listNamespaces(this.baseNamespace).stream().map(n -> n.level(n.levels().length - 1)).collect(Collectors.toList());
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (this.asNamespaceCatalog == null) {
            if (!this.getDefaultDatabase().equals(databaseName)) {
                throw new DatabaseNotExistException(this.getName(), databaseName);
            }
            return new CatalogDatabaseImpl(Maps.newHashMap(), "");
        }
        try {
            HashMap<String, String> metadata = Maps.newHashMap(this.asNamespaceCatalog.loadNamespaceMetadata(this.toNamespace(databaseName)));
            String comment = (String)metadata.remove("comment");
            return new CatalogDatabaseImpl(metadata, comment);
        }
        catch (NoSuchNamespaceException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName, (Throwable)e);
        }
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            this.getDatabase(databaseName);
            return true;
        }
        catch (DatabaseNotExistException ignore) {
            return false;
        }
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        this.createDatabase(name, this.mergeComment(database.getProperties(), database.getComment()), ignoreIfExists);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDatabase(String databaseName, Map<String, String> metadata, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        if (this.asNamespaceCatalog == null) throw new UnsupportedOperationException("Namespaces are not supported by catalog: " + this.getName());
        try {
            this.asNamespaceCatalog.createNamespace(this.toNamespace(databaseName), metadata);
            return;
        }
        catch (AlreadyExistsException e) {
            if (ignoreIfExists) return;
            throw new DatabaseAlreadyExistException(this.getName(), databaseName, (Throwable)e);
        }
    }

    private Map<String, String> mergeComment(Map<String, String> metadata, String comment) {
        HashMap<String, String> ret = Maps.newHashMap(metadata);
        if (metadata.containsKey("comment")) {
            throw new CatalogException("Database properties should not contain key: 'comment'.");
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)comment)) {
            ret.put("comment", comment);
        }
        return ret;
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        block7: {
            if (this.asNamespaceCatalog != null) {
                try {
                    boolean success = this.asNamespaceCatalog.dropNamespace(this.toNamespace(name));
                    if (!success && !ignoreIfNotExists) {
                        throw new DatabaseNotExistException(this.getName(), name);
                    }
                    break block7;
                }
                catch (NoSuchNamespaceException e) {
                    if (!ignoreIfNotExists) {
                        throw new DatabaseNotExistException(this.getName(), name, (Throwable)e);
                    }
                    break block7;
                }
                catch (NamespaceNotEmptyException e) {
                    throw new DatabaseNotEmptyException(this.getName(), name, (Throwable)e);
                }
            }
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), name);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        if (this.asNamespaceCatalog != null) {
            Namespace namespace = this.toNamespace(name);
            HashMap<String, String> updates = Maps.newHashMap();
            HashSet<String> removals = Sets.newHashSet();
            try {
                Map<String, String> oldProperties = this.asNamespaceCatalog.loadNamespaceMetadata(namespace);
                Map<String, String> newProperties = this.mergeComment(newDatabase.getProperties(), newDatabase.getComment());
                for (String string : oldProperties.keySet()) {
                    if (newProperties.containsKey(string)) continue;
                    removals.add(string);
                }
                for (Map.Entry entry : newProperties.entrySet()) {
                    if (((String)entry.getValue()).equals(oldProperties.get(entry.getKey()))) continue;
                    updates.put((String)entry.getKey(), (String)entry.getValue());
                }
                if (!updates.isEmpty()) {
                    this.asNamespaceCatalog.setProperties(namespace, updates);
                }
                if (removals.isEmpty()) return;
                this.asNamespaceCatalog.removeProperties(namespace, removals);
                return;
            }
            catch (NoSuchNamespaceException e) {
                if (ignoreIfNotExists) return;
                throw new DatabaseNotExistException(this.getName(), name, (Throwable)e);
            }
        } else {
            if (this.getDefaultDatabase().equals(name)) {
                throw new CatalogException("Can not alter the default database when the iceberg catalog doesn't support namespaces.");
            }
            if (ignoreIfNotExists) return;
            throw new DatabaseNotExistException(this.getName(), name);
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.icebergCatalog.listTables(this.toNamespace(databaseName)).stream().map(TableIdentifier::name).collect(Collectors.toList());
        }
        catch (NoSuchNamespaceException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName, (Throwable)e);
        }
    }

    public CatalogTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Table table = this.loadIcebergTable(tablePath);
        return FlinkCatalog.toCatalogTable(table);
    }

    private Table loadIcebergTable(ObjectPath tablePath) throws TableNotExistException {
        try {
            Table table = this.icebergCatalog.loadTable(this.toIdentifier(tablePath));
            if (this.cacheEnabled) {
                table.refresh();
            }
            return table;
        }
        catch (NoSuchTableException e) {
            throw new TableNotExistException(this.getName(), tablePath, (Throwable)e);
        }
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        return this.icebergCatalog.tableExists(this.toIdentifier(tablePath));
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        block2: {
            try {
                this.icebergCatalog.dropTable(this.toIdentifier(tablePath));
            }
            catch (NoSuchTableException e) {
                if (ignoreIfNotExists) break block2;
                throw new TableNotExistException(this.getName(), tablePath, (Throwable)e);
            }
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        try {
            this.icebergCatalog.renameTable(this.toIdentifier(tablePath), this.toIdentifier(new ObjectPath(tablePath.getDatabaseName(), newTableName)));
        }
        catch (NoSuchTableException e) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath, (Throwable)e);
            }
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistException(this.getName(), tablePath, (Throwable)e);
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws CatalogException, TableAlreadyExistException {
        if (Objects.equals(table.getOptions().get("connector"), "iceberg")) {
            throw new IllegalArgumentException("Cannot create the table with 'connector'='iceberg' table property in an iceberg catalog, Please create table with 'connector'='iceberg' property in a non-iceberg catalog or create table without 'connector'='iceberg' related properties in an iceberg table.");
        }
        this.createIcebergTable(tablePath, table, ignoreIfExists);
    }

    void createIcebergTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws CatalogException, TableAlreadyExistException {
        block4: {
            FlinkCatalog.validateFlinkTable(table);
            Schema icebergSchema = FlinkSchemaUtil.convert(table.getSchema());
            PartitionSpec spec = FlinkCatalog.toPartitionSpec(((CatalogTable)table).getPartitionKeys(), icebergSchema);
            ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();
            String location = null;
            for (Map.Entry entry : table.getOptions().entrySet()) {
                if ("location".equalsIgnoreCase((String)entry.getKey())) {
                    location = (String)entry.getValue();
                    continue;
                }
                properties.put((String)entry.getKey(), (String)entry.getValue());
            }
            try {
                this.icebergCatalog.createTable(this.toIdentifier(tablePath), icebergSchema, spec, location, properties.build());
            }
            catch (AlreadyExistsException e) {
                if (ignoreIfExists) break block4;
                throw new TableAlreadyExistException(this.getName(), tablePath, (Throwable)e);
            }
        }
    }

    private static void validateTableSchemaAndPartition(CatalogTable ct1, CatalogTable ct2) {
        TableSchema ts1 = ct1.getSchema();
        TableSchema ts2 = ct2.getSchema();
        boolean equalsPrimary = false;
        if (ts1.getPrimaryKey().isPresent() && ts2.getPrimaryKey().isPresent()) {
            equalsPrimary = Objects.equals(((UniqueConstraint)ts1.getPrimaryKey().get()).getType(), ((UniqueConstraint)ts2.getPrimaryKey().get()).getType()) && Objects.equals(((UniqueConstraint)ts1.getPrimaryKey().get()).getColumns(), ((UniqueConstraint)ts2.getPrimaryKey().get()).getColumns());
        } else if (!ts1.getPrimaryKey().isPresent() && !ts2.getPrimaryKey().isPresent()) {
            equalsPrimary = true;
        }
        if (!(Objects.equals(ts1.getTableColumns(), ts2.getTableColumns()) && Objects.equals(ts1.getWatermarkSpecs(), ts2.getWatermarkSpecs()) && equalsPrimary)) {
            throw new UnsupportedOperationException("Altering schema is not supported yet.");
        }
        if (!ct1.getPartitionKeys().equals(ct2.getPartitionKeys())) {
            throw new UnsupportedOperationException("Altering partition keys is not supported yet.");
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws CatalogException, TableNotExistException {
        Table icebergTable;
        FlinkCatalog.validateFlinkTable(newTable);
        try {
            icebergTable = this.loadIcebergTable(tablePath);
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
            return;
        }
        CatalogTable table = FlinkCatalog.toCatalogTable(icebergTable);
        FlinkCatalog.validateTableSchemaAndPartition(table, (CatalogTable)newTable);
        Map oldProperties = table.getOptions();
        HashMap<String, String> setProperties = Maps.newHashMap();
        String setLocation = null;
        String setSnapshotId = null;
        String pickSnapshotId = null;
        for (Map.Entry entry : newTable.getOptions().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (Objects.equals(value, oldProperties.get(key))) continue;
            if ("location".equalsIgnoreCase(key)) {
                setLocation = value;
                continue;
            }
            if ("current-snapshot-id".equalsIgnoreCase(key)) {
                setSnapshotId = value;
                continue;
            }
            if ("cherry-pick-snapshot-id".equalsIgnoreCase(key)) {
                pickSnapshotId = value;
                continue;
            }
            setProperties.put(key, value);
        }
        oldProperties.keySet().forEach(k -> {
            if (!newTable.getOptions().containsKey(k)) {
                setProperties.put((String)k, (String)null);
            }
        });
        FlinkCatalog.commitChanges(icebergTable, setLocation, setSnapshotId, pickSnapshotId, setProperties);
    }

    private static void validateFlinkTable(CatalogBaseTable table) {
        Preconditions.checkArgument(table instanceof CatalogTable, "The Table should be a CatalogTable.");
        TableSchema schema = table.getSchema();
        schema.getTableColumns().forEach(column -> {
            if (!FlinkCompatibilityUtil.isPhysicalColumn(column)) {
                throw new UnsupportedOperationException("Creating table with computed columns is not supported yet.");
            }
        });
        if (!schema.getWatermarkSpecs().isEmpty()) {
            throw new UnsupportedOperationException("Creating table with watermark specs is not supported yet.");
        }
    }

    private static PartitionSpec toPartitionSpec(List<String> partitionKeys, Schema icebergSchema) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor(icebergSchema);
        partitionKeys.forEach(builder::identity);
        return builder.build();
    }

    private static List<String> toPartitionKeys(PartitionSpec spec, Schema icebergSchema) {
        ImmutableList.Builder partitionKeysBuilder = ImmutableList.builder();
        for (PartitionField field : spec.fields()) {
            if (field.transform().isIdentity()) {
                partitionKeysBuilder.add(icebergSchema.findColumnName(field.sourceId()));
                continue;
            }
            return Collections.emptyList();
        }
        return partitionKeysBuilder.build();
    }

    private static void commitChanges(Table table, String setLocation, String setSnapshotId, String pickSnapshotId, Map<String, String> setProperties) {
        long newSnapshotId;
        Preconditions.checkArgument(setSnapshotId == null || pickSnapshotId == null, "Cannot set the current snapshot ID and cherry-pick snapshot changes");
        if (setSnapshotId != null) {
            newSnapshotId = Long.parseLong(setSnapshotId);
            table.manageSnapshots().setCurrentSnapshot(newSnapshotId).commit();
        }
        if (pickSnapshotId != null) {
            newSnapshotId = Long.parseLong(pickSnapshotId);
            table.manageSnapshots().cherrypick(newSnapshotId).commit();
        }
        Transaction transaction = table.newTransaction();
        if (setLocation != null) {
            transaction.updateLocation().setLocation(setLocation).commit();
        }
        if (!setProperties.isEmpty()) {
            UpdateProperties updateProperties = transaction.updateProperties();
            setProperties.forEach((k, v) -> {
                if (v == null) {
                    updateProperties.remove((String)k);
                } else {
                    updateProperties.set((String)k, (String)v);
                }
            });
            updateProperties.commit();
        }
        transaction.commitTransaction();
    }

    static CatalogTable toCatalogTable(Table table) {
        TableSchema schema = FlinkSchemaUtil.toSchema(table.schema());
        List<String> partitionKeys = FlinkCatalog.toPartitionKeys(table.spec(), table.schema());
        return new CatalogTableImpl(schema, partitionKeys, table.properties(), null);
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new FlinkDynamicTableFactory(this));
    }

    CatalogLoader getCatalogLoader() {
        return this.catalogLoader;
    }

    public List<String> listViews(String databaseName) throws CatalogException {
        return Collections.emptyList();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listFunctions(String dbName) throws CatalogException {
        return Collections.emptyList();
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Table table = this.loadIcebergTable(tablePath);
        if (table.spec().isUnpartitioned()) {
            throw new TableNotPartitionedException(this.icebergCatalog.name(), tablePath);
        }
        HashSet<CatalogPartitionSpec> set = Sets.newHashSet();
        try (CloseableIterable tasks = table.newScan().planFiles();){
            for (DataFile dataFile : CloseableIterable.transform(tasks, ContentScanTask::file)) {
                HashMap<String, String> map = Maps.newHashMap();
                StructLike structLike = dataFile.partition();
                PartitionSpec spec = table.specs().get(dataFile.specId());
                for (int i = 0; i < structLike.size(); ++i) {
                    map.put(spec.fields().get(i).name(), String.valueOf(structLike.get(i, Object.class)));
                }
                set.add(new CatalogPartitionSpec(map));
            }
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Failed to list partitions of table %s", tablePath), (Throwable)e);
        }
        return Lists.newArrayList(set);
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }
}

