/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class FlinkConfParser {
    private final Map<String, String> tableProperties;
    private final Map<String, String> options;
    private final ReadableConfig readableConfig;

    FlinkConfParser(Table table, Map<String, String> options, ReadableConfig readableConfig) {
        this.tableProperties = table.properties();
        this.options = options;
        this.readableConfig = readableConfig;
    }

    public BooleanConfParser booleanConf() {
        return new BooleanConfParser();
    }

    public IntConfParser intConf() {
        return new IntConfParser();
    }

    public LongConfParser longConf() {
        return new LongConfParser();
    }

    public StringConfParser stringConf() {
        return new StringConfParser();
    }

    abstract class ConfParser<ThisT, T> {
        private final List<String> optionNames = Lists.newArrayList();
        private String tablePropertyName;
        private ConfigOption<T> configOption;

        ConfParser() {
        }

        protected abstract ThisT self();

        public ThisT option(String name) {
            this.optionNames.add(name);
            return this.self();
        }

        public ThisT flinkConfig(ConfigOption<T> newConfigOption) {
            this.configOption = newConfigOption;
            return this.self();
        }

        public ThisT tableProperty(String name) {
            this.tablePropertyName = name;
            return this.self();
        }

        protected T parse(Function<String, T> conversion, T defaultValue) {
            Object propertyValue;
            if (!this.optionNames.isEmpty()) {
                for (String optionName : this.optionNames) {
                    String optionValue = (String)FlinkConfParser.this.options.get(optionName);
                    if (optionValue == null) continue;
                    return conversion.apply(optionValue);
                }
            }
            if (this.configOption != null && (propertyValue = FlinkConfParser.this.readableConfig.get(this.configOption)) != null) {
                return (T)propertyValue;
            }
            if (this.tablePropertyName != null && (propertyValue = (String)FlinkConfParser.this.tableProperties.get(this.tablePropertyName)) != null) {
                return conversion.apply((String)propertyValue);
            }
            return defaultValue;
        }
    }

    class StringConfParser
    extends ConfParser<StringConfParser, String> {
        private String defaultValue;

        StringConfParser() {
        }

        @Override
        protected StringConfParser self() {
            return this;
        }

        public StringConfParser defaultValue(String value) {
            this.defaultValue = value;
            return this.self();
        }

        public String parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Function.identity(), this.defaultValue);
        }

        public String parseOptional() {
            return this.parse(Function.identity(), null);
        }
    }

    class LongConfParser
    extends ConfParser<LongConfParser, Long> {
        private Long defaultValue;

        LongConfParser() {
        }

        @Override
        protected LongConfParser self() {
            return this;
        }

        public LongConfParser defaultValue(long value) {
            this.defaultValue = value;
            return this.self();
        }

        public long parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Long::parseLong, this.defaultValue);
        }

        public Long parseOptional() {
            return this.parse(Long::parseLong, null);
        }
    }

    class IntConfParser
    extends ConfParser<IntConfParser, Integer> {
        private Integer defaultValue;

        IntConfParser() {
        }

        @Override
        protected IntConfParser self() {
            return this;
        }

        public IntConfParser defaultValue(int value) {
            this.defaultValue = value;
            return this.self();
        }

        public int parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Integer::parseInt, this.defaultValue);
        }

        public Integer parseOptional() {
            return this.parse(Integer::parseInt, null);
        }
    }

    class BooleanConfParser
    extends ConfParser<BooleanConfParser, Boolean> {
        private Boolean defaultValue;

        BooleanConfParser() {
        }

        @Override
        protected BooleanConfParser self() {
            return this;
        }

        public BooleanConfParser defaultValue(boolean value) {
            this.defaultValue = value;
            return this.self();
        }

        public BooleanConfParser defaultValue(String value) {
            this.defaultValue = Boolean.parseBoolean(value);
            return this.self();
        }

        public boolean parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Boolean::parseBoolean, this.defaultValue);
        }
    }
}

