/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.sink.FlinkSink;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class IcebergTableSink
implements DynamicTableSink,
SupportsPartitioning,
SupportsOverwrite {
    private final TableLoader tableLoader;
    private final TableSchema tableSchema;
    private final ReadableConfig readableConfig;
    private final Map<String, String> writeProps;
    private boolean overwrite = false;

    private IcebergTableSink(IcebergTableSink toCopy) {
        this.tableLoader = toCopy.tableLoader;
        this.tableSchema = toCopy.tableSchema;
        this.overwrite = toCopy.overwrite;
        this.readableConfig = toCopy.readableConfig;
        this.writeProps = toCopy.writeProps;
    }

    public IcebergTableSink(TableLoader tableLoader, TableSchema tableSchema, ReadableConfig readableConfig, Map<String, String> writeProps) {
        this.tableLoader = tableLoader;
        this.tableSchema = tableSchema;
        this.readableConfig = readableConfig;
        this.writeProps = writeProps;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        Preconditions.checkState((!this.overwrite || context.isBounded() ? 1 : 0) != 0, (Object)"Unbounded data stream doesn't support overwrite operation.");
        List equalityColumns = this.tableSchema.getPrimaryKey().map(UniqueConstraint::getColumns).orElseGet(ImmutableList::of);
        return (providerContext, dataStream) -> FlinkSink.forRowData((DataStream<RowData>)dataStream).tableLoader(this.tableLoader).tableSchema(this.tableSchema).equalityFieldColumns(equalityColumns).overwrite(this.overwrite).setAll(this.writeProps).flinkConf(this.readableConfig).append();
    }

    public void applyStaticPartition(Map<String, String> partition) {
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink copy() {
        return new IcebergTableSink(this);
    }

    public String asSummaryString() {
        return "Iceberg table sink";
    }

    public void applyOverwrite(boolean newOverwrite) {
        this.overwrite = newOverwrite;
    }
}

